/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.lib.position;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.leralix.lib.position.Vector2D;
import org.leralix.lib.position.Vector3D;

public class DoubleVector2D {
    protected double x;
    protected double z;
    protected String worldID;

    public DoubleVector2D(double x, double z, String worldID) {
        this.x = x;
        this.z = z;
        this.worldID = worldID;
    }

    public DoubleVector2D(Location location) {
        this.x = location.getBlockX();
        this.z = location.getBlockZ();
        this.worldID = location.getWorld().getUID().toString();
    }

    public DoubleVector2D(Chunk chunk) {
        this.x = chunk.getX();
        this.z = chunk.getZ();
        this.worldID = chunk.getWorld().getUID().toString();
    }

    public DoubleVector2D(Vector3D vector) {
        this.x = vector.getX();
        this.z = vector.getZ();
        this.worldID = vector.getWorldID().toString();
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public UUID getWorldID() {
        return UUID.fromString(this.worldID);
    }

    public World getWorld() {
        return Bukkit.getWorld((UUID)this.getWorldID());
    }

    public double getDistance(DoubleVector2D other) {
        return Math.sqrt(Math.pow(this.x - other.x, 2.0) + Math.pow(this.z - other.z, 2.0));
    }

    public double getArea(DoubleVector2D other) {
        double lineX = Math.abs(this.x - other.getX());
        double lineZ = Math.abs(this.z - other.getZ());
        return lineX * lineZ;
    }

    public Vector2D get2DVector() {
        return new Vector2D((int)this.x, (int)this.z, this.worldID);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleVector2D vector3D = (DoubleVector2D)o;
        return this.x == vector3D.x && this.z == vector3D.z && Objects.equals(this.worldID, vector3D.worldID);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.z, this.worldID);
    }

    public String toString() {
        return "Vector2D{x=" + this.x + ", z=" + this.z + ", worldID='" + this.worldID + "'}";
    }
}

