/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.lib.position;

import java.util.Objects;
import org.bukkit.Location;
import org.leralix.lib.position.DoubleVector2D;
import org.leralix.lib.position.Vector3D;

public class DoubleVector3D
extends DoubleVector2D {
    protected double y;

    public DoubleVector3D(double x, double y, double z, String worldID) {
        super(x, z, worldID);
        this.y = y;
    }

    public DoubleVector3D(Location location) {
        super(location.getBlockX(), location.getBlockZ(), location.getWorld().getUID().toString());
        this.y = location.getBlockY();
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getDistance(DoubleVector3D other) {
        return Math.sqrt(Math.pow(this.x - other.x, 2.0) + Math.pow(this.z - other.z, 2.0) + Math.pow(this.y - other.y, 2.0));
    }

    public double getArea(DoubleVector3D other) {
        double lineX = Math.abs(this.x - other.getX());
        double lineY = Math.abs(this.y - other.getY());
        double lineZ = Math.abs(this.z - other.getZ());
        return lineX * lineY * lineZ;
    }

    public Location getLocation() {
        return new Location(this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    public Vector3D get3DVector() {
        return new Vector3D(this.get2DVector(), (int)this.y);
    }

    @Override
    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleVector3D vector3D = (DoubleVector3D)o;
        return this.x == vector3D.x && this.y == vector3D.y && this.z == vector3D.z && Objects.equals(this.worldID, vector3D.worldID);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.worldID);
    }
}

