/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.lib.position;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.leralix.lib.position.Vector3D;

public class Vector2D {
    protected int x;
    protected int z;
    protected String worldID;

    public Vector2D(int x, int z, String worldID) {
        this.x = x;
        this.z = z;
        this.worldID = worldID;
    }

    public Vector2D(Location location) {
        this.x = location.getBlockX();
        this.z = location.getBlockZ();
        this.worldID = location.getWorld().getUID().toString();
    }

    public Vector2D(Chunk chunk) {
        this.x = chunk.getX();
        this.z = chunk.getZ();
        this.worldID = chunk.getWorld().getUID().toString();
    }

    public Vector2D(Vector2D vector) {
        this.x = vector.getX();
        this.z = vector.getZ();
        this.worldID = vector.getWorldID().toString();
    }

    public Vector2D(Vector3D vector) {
        this.x = vector.getX();
        this.z = vector.getZ();
        this.worldID = vector.getWorldID().toString();
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public UUID getWorldID() {
        return UUID.fromString(this.worldID);
    }

    public World getWorld() {
        return Bukkit.getWorld((UUID)this.getWorldID());
    }

    public Chunk getChunk() {
        return this.getWorld().getChunkAt(this.x, this.z);
    }

    public double getDistance(Vector2D other) {
        return Math.sqrt(Math.pow(this.x - other.x, 2.0) + Math.pow(this.z - other.z, 2.0));
    }

    public int getArea(Vector2D other) {
        int lineX = Math.abs(this.x - other.getX());
        int lineZ = Math.abs(this.z - other.getZ());
        return lineX * lineZ;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector2D vector3D = (Vector2D)o;
        return this.x == vector3D.x && this.z == vector3D.z && Objects.equals(this.worldID, vector3D.worldID);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.z, this.worldID);
    }

    public String toString() {
        return "Vector2D{x=" + this.x + ", z=" + this.z + ", worldID='" + this.worldID + "'}";
    }
}

