/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.lib.position;

import java.util.Objects;
import org.bukkit.Location;
import org.leralix.lib.position.Vector2D;

public class Vector3D
extends Vector2D {
    protected int y;

    public Vector3D(int x, int y, int z, String worldID) {
        super(x, z, worldID);
        this.y = y;
    }

    public Vector3D(Vector2D vector2D, int y) {
        super(vector2D);
        this.y = y;
    }

    public Vector3D(Location location) {
        super(location.getBlockX(), location.getBlockZ(), location.getWorld().getUID().toString());
        this.y = location.getBlockY();
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public double getDistance(Vector3D other) {
        return Math.sqrt(Math.pow(this.x - other.x, 2.0) + Math.pow(this.z - other.z, 2.0) + Math.pow(this.y - other.y, 2.0));
    }

    public int getArea(Vector3D other) {
        int lineX = Math.abs(this.x - other.getX());
        int lineY = Math.abs(this.y - other.getY());
        int lineZ = Math.abs(this.z - other.getZ());
        return lineX * lineY * lineZ;
    }

    public Location getLocation() {
        return new Location(this.getWorld(), (double)this.getX(), (double)this.getY(), (double)this.getZ());
    }

    @Override
    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector3D vector3D = (Vector3D)o;
        return this.x == vector3D.x && this.y == vector3D.y && this.z == vector3D.z && Objects.equals(this.worldID, vector3D.worldID);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.worldID);
    }
}

