/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.lib.utils;

import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CustomNBT {
    private CustomNBT() {
        throw new IllegalStateException("Utility class");
    }

    public static void addCustomStringTag(Plugin pluginToRegister, ItemStack item, String tagName, String tagValue) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(new NamespacedKey(pluginToRegister, tagName), PersistentDataType.STRING, (Object)tagValue);
            item.setItemMeta(meta);
        }
    }

    public static String getCustomStringTag(Plugin plugin, ItemStack item, String tagName) {
        if (item.getItemMeta() == null) {
            return null;
        }
        if (item.getItemMeta().getPersistentDataContainer().has(new NamespacedKey(plugin, tagName), PersistentDataType.STRING)) {
            return (String)item.getItemMeta().getPersistentDataContainer().get(new NamespacedKey(plugin, tagName), PersistentDataType.STRING);
        }
        return null;
    }

    public static void setBockMetaData(Plugin plugin, Block block, String metaData, String value) {
        block.setMetadata(metaData, (MetadataValue)new FixedMetadataValue(plugin, (Object)value));
    }

    public static String getBockMetaData(Block block, String metaData) {
        if (!block.hasMetadata(metaData)) {
            return null;
        }
        return ((MetadataValue)block.getMetadata(metaData).get(0)).asString();
    }
}

