/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.lib.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class HeadUtils {
    private static final UUID RANDOM_UUID = UUID.fromString("92864445-51c5-4c3b-9039-517c9927d1b4");

    public static ItemStack getPlayerHead(String headName, OfflinePlayer offlinePlayer, List<String> lore) {
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)playerHead.getItemMeta();
        if (skullMeta == null) {
            return playerHead;
        }
        skullMeta.setDisplayName(String.valueOf(ChatColor.RESET) + String.valueOf(ChatColor.GREEN) + headName);
        skullMeta.setOwningPlayer(offlinePlayer);
        if (lore != null) {
            skullMeta.setLore(lore);
        }
        playerHead.setItemMeta((ItemMeta)skullMeta);
        return playerHead;
    }

    public static ItemStack getPlayerHead(String headName, OfflinePlayer offlinePlayer, String ... loreLines) {
        List<String> lore = Arrays.asList(loreLines);
        return HeadUtils.getPlayerHead(headName, offlinePlayer, lore);
    }

    public static ItemStack getPlayerHead(OfflinePlayer offlinePlayer, String ... loreLines) {
        List<String> lore = Arrays.asList(loreLines);
        return HeadUtils.getPlayerHead(offlinePlayer.getName(), offlinePlayer, lore);
    }

    public static ItemStack getPlayerHead(String headName, OfflinePlayer offlinePlayer) {
        return HeadUtils.getPlayerHead(headName, offlinePlayer, (List<String>)null);
    }

    public static ItemStack getPlayerHead(OfflinePlayer offlinePlayer) {
        return HeadUtils.getPlayerHead(offlinePlayer.getName(), offlinePlayer);
    }

    public static ItemStack makeSkullB64(String name, String base64EncodedString, List<String> lore) {
        return HeadUtils.makeSkullURL(name, HeadUtils.getUrlFromBase64_2(base64EncodedString), lore);
    }

    public static ItemStack makeSkullURL(String name, String url, String ... lore) {
        return HeadUtils.makeSkull(name, HeadUtils.getProfile(HeadUtils.createURL(url)), Arrays.asList(lore));
    }

    public static ItemStack makeSkullURL(String name, String url, List<String> lore) {
        return HeadUtils.makeSkull(name, HeadUtils.getProfile(HeadUtils.createURL(url)), lore);
    }

    public static ItemStack makeSkullURL(String name, URL url, String ... lore) {
        return HeadUtils.makeSkull(name, HeadUtils.getProfile(url), Arrays.asList(lore));
    }

    public static ItemStack makeSkullURL(String name, URL url, List<String> lore) {
        return HeadUtils.makeSkull(name, HeadUtils.getProfile(url), lore);
    }

    public static ItemStack makeSkull(String name, PlayerProfile profile, List<String> lore) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        meta.setOwnerProfile(profile);
        skull.setItemMeta((ItemMeta)meta);
        meta.setDisplayName(String.valueOf(ChatColor.RESET) + String.valueOf(ChatColor.GREEN) + name);
        if (lore != null) {
            meta.setLore(lore);
        }
        skull.setItemMeta((ItemMeta)meta);
        return skull;
    }

    private static PlayerProfile getProfile(URL url) {
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)RANDOM_UUID);
        PlayerTextures textures = profile.getTextures();
        textures.setSkin(url);
        profile.setTextures(textures);
        return profile;
    }

    public static URL getUrlFromBase64_2(String base64) {
        String decoded = new String(Base64.getDecoder().decode(base64));
        JsonObject json = JsonParser.parseString((String)decoded).getAsJsonObject();
        String url = json.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
        return HeadUtils.createURL(url);
    }

    private static URL createURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static ItemStack makeSkullB64(String name, String base64EncodedString) {
        return HeadUtils.makeSkullB64(name, base64EncodedString, (List<String>)null);
    }

    public static ItemStack makeSkullB64(String name, String base64EncodedString, String ... loreLines) {
        List<String> lore = Arrays.asList(loreLines);
        return HeadUtils.makeSkullB64(name, base64EncodedString, lore);
    }

    public static ItemStack makeSkullB64(String name, String base64EncodedString, List<String> lore, String ... loreLines) {
        List<String> lore2 = Arrays.asList(loreLines);
        lore.addAll(lore2);
        return HeadUtils.makeSkullB64(name, base64EncodedString, lore);
    }

    public static ItemStack createCustomItemStack(Material itemMaterial, String itemName) {
        return HeadUtils.createCustomItemStack(itemMaterial, itemName, (List<String>)null);
    }

    public static ItemStack createCustomItemStack(Material itemMaterial, String itemName, String ... loreLines) {
        List<String> lore = Arrays.asList(loreLines);
        return HeadUtils.createCustomItemStack(itemMaterial, itemName, lore);
    }

    public static ItemStack createCustomItemStack(Material itemMaterial, String itemName, List<String> lore, String ... loreLines) {
        List<String> lore2 = Arrays.asList(loreLines);
        lore.addAll(lore2);
        return HeadUtils.createCustomItemStack(itemMaterial, itemName, lore2);
    }

    public static ItemStack createCustomItemStack(Material itemMaterial, String itemName, List<String> lore) {
        ItemStack item = new ItemStack(itemMaterial);
        return HeadUtils.createCustomItemStack(item, itemName, lore);
    }

    public static ItemStack createCustomItemStack(ItemStack item, String itemName, List<String> lore) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.RESET) + String.valueOf(ChatColor.GREEN) + itemName);
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack createCustomItemStack(ItemStack item, String itemName, String ... lore) {
        return HeadUtils.createCustomItemStack(item, itemName, Arrays.asList(lore));
    }

    public static void setLore(ItemStack itemStack, List<String> lore) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setLore(lore);
            itemStack.setItemMeta(itemMeta);
        }
    }

    public static void setLore(ItemStack itemStack, String ... loreLines) {
        List<String> lore = Arrays.asList(loreLines);
        HeadUtils.setLore(itemStack, lore);
    }

    public static void setLore(ItemStack itemStack, List<String> lore, String ... loreLines) {
        List<String> lore2 = Arrays.asList(loreLines);
        lore.addAll(lore2);
        HeadUtils.setLore(itemStack, lore);
    }

    public static void addLore(ItemStack itemStack, String ... loreLines) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            ArrayList<String> lore = itemMeta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            lore.addAll(Arrays.asList(loreLines));
            itemMeta.setLore(lore);
        }
        itemStack.setItemMeta(itemMeta);
    }
}

