/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.lib.utils.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.leralix.lib.SphereLib;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.PluginSideBlacklist;

public class ConfigUtil {
    static final Map<ConfigTag, FileConfiguration> configs = new EnumMap<ConfigTag, FileConfiguration>(ConfigTag.class);

    ConfigUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static FileConfiguration getCustomConfig(ConfigTag tag) {
        return configs.get((Object)tag);
    }

    public static void addCustomConfig(Plugin plugin, String fileName, ConfigTag tag) {
        File configFile = new File(plugin.getDataFolder(), fileName);
        if (!configFile.exists()) {
            plugin.getLogger().severe(() -> fileName + " does not exist!");
            return;
        }
        ConfigUtil.addCustomConfig(configFile, tag);
    }

    public static void addCustomConfig(File file, ConfigTag tag) {
        configs.put(tag, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
    }

    static boolean containsKey(Collection<String> blackListedWords, String key) {
        for (String word : blackListedWords) {
            if (!key.startsWith(word)) continue;
            return true;
        }
        return false;
    }

    public static void saveAndUpdateResource(Plugin plugin, String fileName) {
        ConfigUtil.saveAndUpdateResource(plugin, fileName, Collections.emptyList());
    }

    public static void saveAndUpdateResource(Plugin plugin, String fileName, Collection<String> sectionBlacklist) {
        File currentFile = new File(plugin.getDataFolder(), fileName);
        if (!currentFile.exists()) {
            plugin.saveResource(fileName, false);
            return;
        }
        InputStream baseFile = plugin.getResource(fileName);
        List<String> baseFileLines = ConfigUtil.loadFileAsList(baseFile);
        List<String> currentFileLines = ConfigUtil.loadFileAsList(currentFile);
        Optional<List<String>> test = ConfigUtil.mergeAndPreserveLines(baseFileLines, currentFileLines, sectionBlacklist);
        test.ifPresent(list -> {
            ConfigUtil.writeToFile(list, currentFile);
            plugin.getLogger().info(() -> "The file " + fileName + " has been updated with missing lines.");
        });
    }

    static List<String> loadFileAsList(InputStream file) {
        ArrayList<String> arrayList;
        if (file == null) {
            return Collections.emptyList();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(file));
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            arrayList = lines;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                SphereLib.getPlugin().getLogger().warning("Error while loading file as list : " + String.valueOf(file));
                return Collections.emptyList();
            }
        }
        reader.close();
        return arrayList;
    }

    static List<String> loadFileAsList(File file) {
        ArrayList<String> arrayList;
        if (file == null) {
            return Collections.emptyList();
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            arrayList = lines;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                SphereLib.getPlugin().getLogger().warning("Error while loading file as list : " + String.valueOf(file));
                return Collections.emptyList();
            }
        }
        reader.close();
        return arrayList;
    }

    static Optional<List<String>> mergeAndPreserveLines(List<String> pluginFileLines, List<String> actualFileLine) {
        return ConfigUtil.mergeAndPreserveLines(pluginFileLines, actualFileLine, Collections.emptyList());
    }

    static Optional<List<String>> mergeAndPreserveLines(List<String> pluginFileLines, List<String> actualFileLine, Collection<String> sectionBlacklist) {
        ArrayList<String> mergedLines = new ArrayList<String>();
        boolean updated = false;
        int indexActual = 0;
        int bannedSectionIndentation = 0;
        boolean inBannedSection = false;
        PluginSideBlacklist pluginSideBlacklist = new PluginSideBlacklist(sectionBlacklist);
        for (String pluginFileLine : pluginFileLines) {
            if (inBannedSection) {
                while (actualFileLine.size() > indexActual && inBannedSection) {
                    String actualLine = actualFileLine.get(indexActual);
                    if (ConfigUtil.getNbIndentation(actualLine) <= bannedSectionIndentation && !actualLine.isBlank()) {
                        inBannedSection = false;
                        continue;
                    }
                    mergedLines.add(actualLine);
                    ++indexActual;
                }
            }
            if (pluginSideBlacklist.isInBackListPart(pluginFileLine)) continue;
            if (indexActual >= actualFileLine.size()) {
                mergedLines.add(pluginFileLine);
                updated = true;
                continue;
            }
            String currentLine = actualFileLine.get(indexActual);
            String pluginKey = ConfigUtil.extractKey(pluginFileLine);
            String currentKey = ConfigUtil.extractKey(currentLine);
            if (currentLine.isBlank() && pluginFileLine.isBlank()) {
                ++indexActual;
                mergedLines.add(pluginFileLine);
                continue;
            }
            if (ConfigUtil.containsKey(sectionBlacklist, pluginKey)) {
                inBannedSection = true;
                bannedSectionIndentation = ConfigUtil.getNbIndentation(pluginFileLine);
                ++indexActual;
                mergedLines.add(pluginFileLine);
                if (currentKey.equals(pluginKey)) continue;
                updated = true;
                continue;
            }
            int existingIndex = ConfigUtil.findLineIndexWithKey(actualFileLine, indexActual - 1, pluginKey);
            if (existingIndex != -1) {
                if (existingIndex != indexActual) {
                    updated = true;
                }
                mergedLines.add(actualFileLine.get(existingIndex));
                indexActual = existingIndex + 1;
                continue;
            }
            if (pluginKey.equals(currentKey)) {
                mergedLines.add(currentLine);
                ++indexActual;
                continue;
            }
            mergedLines.add(pluginFileLine);
            updated = true;
        }
        return updated ? Optional.of(mergedLines) : Optional.empty();
    }

    private static int findLineIndexWithKey(List<String> lines, int startIndex, String key) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < lines.size(); ++i) {
            if (!ConfigUtil.extractKey(lines.get(i)).equals(key)) continue;
            return i;
        }
        return -1;
    }

    static int getNbIndentation(String pluginFileLine) {
        int i;
        for (i = 0; i < pluginFileLine.length() && pluginFileLine.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    static String extractKey(String line) {
        if (line == null) {
            return "";
        }
        if ((line = line.trim()).isEmpty()) {
            return "";
        }
        if (line.startsWith("#")) {
            return line;
        }
        if (line.contains(":")) {
            return line.split(":")[0].trim();
        }
        return line;
    }

    static void writeToFile(List<String> lines, File fileToWrite) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(fileToWrite, false));){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
        }
        catch (Exception e) {
            SphereLib.getPlugin().getLogger().warning("Error while writing to file : " + String.valueOf(fileToWrite));
        }
    }
}

