/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.lib.utils.particles;

import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.leralix.lib.position.Vector3D;
import org.leralix.lib.utils.particles.ParticleTask;

public class ParticleUtils {
    private ParticleUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void drawBox(Plugin plugin, Player player, Vector3D point1, Vector3D point2, int seconds, Particle particle) {
        ParticleTask particleTask = new ParticleTask(player, seconds, () -> ParticleUtils.drawBox(player, point1, point2, particle));
        particleTask.runTaskTimer(plugin, 0L, 20L);
    }

    public static void drawLine(Plugin plugin, Player player, Vector3D point1, Vector3D point2, int seconds, Particle particle) {
        ParticleTask particleTask = new ParticleTask(player, seconds, () -> ParticleUtils.drawLine(player, point1, point2, particle));
        particleTask.runTaskTimer(plugin, 0L, 20L);
    }

    public static void drawPane(Plugin plugin, Player player, Vector3D point1, Vector3D point2, int seconds, Particle particle) {
        ParticleTask particleTask = new ParticleTask(player, seconds, () -> ParticleUtils.drawPane(player, point1, point2, particle));
        particleTask.runTaskTimer(plugin, 0L, 20L);
    }

    private static void drawPane(Player player, Vector3D point1, Vector3D point2, Particle particle) {
        double minX = Math.min(point1.getX(), point2.getX());
        double minY = Math.min(point1.getY(), point2.getY());
        double minZ = Math.min(point1.getZ(), point2.getZ());
        double maxX = Math.max(point1.getX(), point2.getX());
        double maxY = Math.max(point1.getY(), point2.getY());
        double maxZ = Math.max(point1.getZ(), point2.getZ());
        if (minX == maxX) {
            ParticleUtils.drawLine(player, minX, minY, maxZ, minX, minY, minZ, particle);
            ParticleUtils.drawLine(player, minX, maxY, maxZ, minX, maxY, minZ, particle);
            ParticleUtils.drawLine(player, minX, minY, minZ, minX, maxY, minZ, particle);
            ParticleUtils.drawLine(player, minX, minY, maxZ, minX, maxY, maxZ, particle);
            return;
        }
        if (minZ == maxZ) {
            ParticleUtils.drawLine(player, minX, minY, minZ, maxX, minY, minZ, particle);
            ParticleUtils.drawLine(player, minX, maxY, minZ, maxX, maxY, minZ, particle);
            ParticleUtils.drawLine(player, minX, minY, minZ, minX, maxY, minZ, particle);
            ParticleUtils.drawLine(player, maxX, minY, minZ, maxX, maxY, minZ, particle);
            return;
        }
        ParticleUtils.drawBox(player, point1, point2, particle);
    }

    private static void drawBox(Player player, Vector3D point1, Vector3D point2, Particle particle) {
        double minX = Math.min(point1.getX(), point2.getX());
        double minY = Math.min(point1.getY(), point2.getY());
        double minZ = Math.min(point1.getZ(), point2.getZ());
        double maxX = (double)Math.max(point1.getX(), point2.getX()) + 1.0;
        double maxY = (double)Math.max(point1.getY(), point2.getY()) + 1.0;
        double maxZ = (double)Math.max(point1.getZ(), point2.getZ()) + 1.0;
        ParticleUtils.drawLine(player, minX, minY, minZ, maxX, minY, minZ, particle);
        ParticleUtils.drawLine(player, maxX, minY, minZ, maxX, minY, maxZ, particle);
        ParticleUtils.drawLine(player, maxX, minY, maxZ, minX, minY, maxZ, particle);
        ParticleUtils.drawLine(player, minX, minY, maxZ, minX, minY, minZ, particle);
        ParticleUtils.drawLine(player, minX, maxY, minZ, maxX, maxY, minZ, particle);
        ParticleUtils.drawLine(player, maxX, maxY, minZ, maxX, maxY, maxZ, particle);
        ParticleUtils.drawLine(player, maxX, maxY, maxZ, minX, maxY, maxZ, particle);
        ParticleUtils.drawLine(player, minX, maxY, maxZ, minX, maxY, minZ, particle);
        ParticleUtils.drawLine(player, minX, minY, minZ, minX, maxY, minZ, particle);
        ParticleUtils.drawLine(player, maxX, minY, minZ, maxX, maxY, minZ, particle);
        ParticleUtils.drawLine(player, maxX, minY, maxZ, maxX, maxY, maxZ, particle);
        ParticleUtils.drawLine(player, minX, minY, maxZ, minX, maxY, maxZ, particle);
    }

    private static void drawLine(Player player, Vector3D point1, Vector3D point2, Particle particle) {
        ParticleUtils.drawLine(player, point1.getX(), point1.getY(), point1.getZ(), point2.getX(), point2.getY(), point2.getZ(), particle);
    }

    private static void drawLine(Player player, double x1, double y1, double z1, double x2, double y2, double z2, Particle particle) {
        double length = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) + Math.pow(z2 - z1, 2.0));
        int amount = (int)(length * 2.0);
        double dx = (x2 - x1) / (double)amount;
        double dy = (y2 - y1) / (double)amount;
        double dz = (z2 - z1) / (double)amount;
        for (int i = 0; i <= amount; ++i) {
            Location loc = new Location(player.getWorld(), x1 + dx * (double)i, y1 + dy * (double)i, z1 + dz * (double)i);
            player.spawnParticle(particle, loc, 0, 0.0, 0.0, 0.0, 1.0);
        }
    }

    private static enum Type {
        BOX,
        LINE;

    }
}

