/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.screens.cosmetics;

import com.stereowalker.unionlib.client.gui.components.CosmeticButton;
import com.stereowalker.unionlib.client.gui.screens.cosmetics.CosmeticsScreen;
import com.stereowalker.unionlib.supporter.CosmeticSelection;
import com.stereowalker.unionlib.supporter.Cosmetics;
import com.stereowalker.unionlib.supporter.OwnedCosmetic;
import com.stereowalker.unionlib.util.ScreenHelper;
import com.stereowalker.unionlib.util.math.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.util.Mth;

public class CosmeticList
extends ContainerObjectSelectionList<Entry> {
    protected CosmeticsScreen screen;
    boolean creatingButtons = false;

    public CosmeticList(Minecraft mcIn, CosmeticsScreen screen) {
        super(mcIn, 150, screen.layout.getContentHeight(), screen.layout.getHeaderHeight(), 50);
        this.screen = screen;
        this.createButtons();
    }

    protected Entry getEntry(int pIndex) {
        if (this.creatingButtons) {
            return new CategoryEntry(this, List.of(new CosmeticButton(0, 0, 40, 40, new CosmeticSelection("", "base", Map.of()), button -> {}), new CosmeticButton(0, 0, 40, 40, new CosmeticSelection("", "base", Map.of()), button -> {}), new CosmeticButton(0, 0, 40, 40, new CosmeticSelection("", "base", Map.of()), button -> {})));
        }
        return (Entry)super.getEntry(pIndex);
    }

    public void createButtons() {
        this.creatingButtons = true;
        this.screen.buttons.values().forEach(this.screen::removeChild);
        this.clearEntries();
        List sorted = Cosmetics.allCosmetics().values().stream().mapMulti((cosmetic, consumer) -> cosmetic.variants().forEach(var -> {
            consumer.accept(new CosmeticSelection(cosmetic.id(), (String)var, Map.of()));
            for (int i = 0; i < cosmetic.segments().size(); ++i) {
                LinkedHashMap<String, Color> map = new LinkedHashMap<String, Color>();
                String segment = cosmetic.segments().get(i);
                map.put(segment, this.screen.col.get(segment));
                cosmetic.segments().forEach(d -> map.putIfAbsent((String)d, new Color(0.0f, 0.0f, 0.0f, 0.5f)));
                CosmeticSelection custom = new CosmeticSelection(cosmetic.id(), "custom", map);
                if (!cosmetic.id().equals(this.screen.currentHeadwear.cosmeticId()) || !Cosmetics.ownsCosmetic(custom)) continue;
                consumer.accept(custom);
            }
        })).sorted(Comparator.comparing(Cosmetics::ownsCosmetic).reversed()).collect(Collectors.toList());
        int rows = Mth.ceil((float)((float)sorted.size() / 3.0f));
        for (int y = 0; y < rows; ++y) {
            ArrayList<CosmeticButton> buttons = new ArrayList<CosmeticButton>();
            for (int x = 0; x < 3; ++x) {
                int i = x + y * 3;
                if (i >= sorted.size()) continue;
                CosmeticSelection cosmetic2 = (CosmeticSelection)sorted.get(i);
                CosmeticButton co = new CosmeticButton(this.width / 2 + 50 + x * 50, this.height - 150 + y * 50, 40, 40, cosmetic2, button -> {
                    List<String> segments = Cosmetics.allCosmetics().get(cosmetic2.cosmeticId()).segments();
                    if (segments.size() > 0 && cosmetic2.colors().size() > 0) {
                        this.screen.segment = ((String[])cosmetic2.colors().keySet().toArray(String[]::new))[0];
                        this.screen.r.setValue(cosmetic.colors().get((Object)this.screen.segment).r);
                        this.screen.g.setValue(cosmetic.colors().get((Object)this.screen.segment).g);
                        this.screen.b.setValue(cosmetic.colors().get((Object)this.screen.segment).b);
                        if (!this.screen.currentHeadwear.equalsNoColor(cosmetic2)) {
                            this.screen.col.clear();
                            List<OwnedCosmetic> owned = Cosmetics.ownedCosmetics().stream().filter(own -> this.screen.currentHeadwear.cosmeticId().equals(own.cosmeticId())).toList();
                            segments.forEach(seg -> this.screen.col.put((String)seg, owned.size() > 0 ? ((OwnedCosmetic)owned.get(0)).colors().getOrDefault(seg, new Color(1.0f, 1.0f, 1.0f)) : new Color(1.0f, 1.0f, 1.0f)));
                        }
                    }
                    this.screen.currentHeadwear = cosmetic2.isCustom() ? new CosmeticSelection(cosmetic2.cosmeticId(), cosmetic2.variant(), this.screen.col) : cosmetic2;
                    this.createButtons();
                });
                this.screen.buttons.put((CosmeticSelection)sorted.get(i), co);
                buttons.add(co);
                this.screen.addChild(co);
            }
            this.addEntry((AbstractSelectionList.Entry)new CategoryEntry(this, buttons));
        }
        this.creatingButtons = false;
        this.screen.buttons.forEach((cosmetic, cobutton) -> cobutton.update(cobutton.isCosmetic(this.screen.currentHeadwear, this.screen.segment), Cosmetics.ownsCosmetic(cosmetic)));
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        return false;
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 20;
    }

    public int getWidth() {
        return 150;
    }

    public int getRowWidth() {
        return 140;
    }

    public int getRowLeft() {
        return this.getX() + (this.getWidth() - this.getRowWidth()) / 2;
    }

    public int getX() {
        return this.screen.width / 2 + 5;
    }

    public class CategoryEntry
    extends Entry {
        private final CosmeticButton[] cosm = new CosmeticButton[3];

        public CategoryEntry(CosmeticList this$0, List<CosmeticButton> buttons) {
            this.cosm[0] = buttons.size() > 0 ? buttons.get(0) : null;
            this.cosm[1] = buttons.size() > 1 ? buttons.get(1) : null;
            this.cosm[2] = buttons.size() > 2 ? buttons.get(2) : null;
        }

        public void render(GuiGraphics pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            for (int i = 0; i < this.cosm.length; ++i) {
                if (this.cosm[i] == null) continue;
                ScreenHelper.setWidgetPosition((AbstractWidget)this.cosm[i], pLeft + i * 50, pTop);
                this.cosm[i].render(pPoseStack, pMouseX, pMouseY, pPartialTick);
            }
        }

        public boolean changeFocus(boolean focus) {
            return false;
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

