/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.screens.inventory;

import com.mojang.blaze3d.platform.InputConstants;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.client.keybindings.KeyBindings;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.inventory.UnionMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;

public class UnionInventoryScreen
extends EffectRenderingInventoryScreen<UnionMenu>
implements RecipeUpdateListener {
    private static final ResourceLocation RECIPE_BUTTON_LOCATION = VersionHelper.toLoc("textures/gui/recipe_button.png");
    private float xMouse;
    private float yMouse;
    private final RecipeBookComponent recipeBookComponent = new RecipeBookComponent();
    private boolean widthTooNarrow;
    private boolean buttonClicked;

    public UnionInventoryScreen(UnionMenu container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.titleLabelX = 97;
    }

    public void containerTick() {
        if (this.minecraft.gameMode.hasInfiniteItems()) {
            this.minecraft.setScreen((Screen)new CreativeModeInventoryScreen((Player)this.minecraft.player, this.minecraft.player.connection.enabledFeatures(), ((Boolean)this.minecraft.options.operatorItemsTab().get()).booleanValue()));
        } else {
            this.recipeBookComponent.tick();
        }
    }

    protected void init() {
        if (this.minecraft.gameMode.hasInfiniteItems()) {
            this.minecraft.setScreen((Screen)new CreativeModeInventoryScreen((Player)this.minecraft.player, this.minecraft.player.connection.enabledFeatures(), ((Boolean)this.minecraft.options.operatorItemsTab().get()).booleanValue()));
        } else {
            super.init();
            this.widthTooNarrow = this.width < 379;
            this.recipeBookComponent.init(this.width, this.height, this.minecraft, this.widthTooNarrow, (RecipeBookMenu)this.menu);
            this.leftPos = this.recipeBookComponent.updateScreenPosition(this.width, this.imageWidth);
            this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 104, this.height / 2 - 22, 20, 18, RecipeBookComponent.RECIPE_BUTTON_SPRITES, p_308204_ -> {
                this.recipeBookComponent.toggleVisibility();
                this.leftPos = this.recipeBookComponent.updateScreenPosition(this.width, this.imageWidth);
                p_308204_.setPosition(this.leftPos + 104, this.height / 2 - 22);
                this.buttonClicked = true;
            }));
            this.addWidget((GuiEventListener)this.recipeBookComponent);
            this.setInitialFocus((GuiEventListener)this.recipeBookComponent);
        }
    }

    protected void renderLabels(GuiGraphics p_281654_, int p_283517_, int p_283464_) {
        p_281654_.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    public void render(GuiGraphics p_283246_, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(p_283246_, pMouseY, pMouseX, pPartialTick);
        if (this.recipeBookComponent.isVisible() && this.widthTooNarrow) {
            this.renderBg(p_283246_, pPartialTick, pMouseX, pMouseY);
            this.recipeBookComponent.render(p_283246_, pMouseX, pMouseY, pPartialTick);
        } else {
            this.recipeBookComponent.render(p_283246_, pMouseX, pMouseY, pPartialTick);
            super.render(p_283246_, pMouseX, pMouseY, pPartialTick);
            this.recipeBookComponent.renderGhostRecipe(p_283246_, this.leftPos, this.topPos, false, pPartialTick);
        }
        this.renderTooltip(p_283246_, pMouseX, pMouseY);
        this.recipeBookComponent.renderTooltip(p_283246_, this.leftPos, this.topPos, pMouseX, pMouseY);
        this.xMouse = pMouseX;
        this.yMouse = pMouseY;
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float p_281299_, int p_283481_, int p_281831_) {
        int i = this.leftPos;
        int j = this.topPos;
        pGuiGraphics.blit(UnionLib.Locations.UNION_INVENTORY_BACKGROUND, i, j, 0, 0, this.imageWidth, this.imageHeight);
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)pGuiGraphics, (int)(i + 26), (int)(j + 8), (int)(i + 75), (int)(j + 78), (int)30, (float)0.0625f, (float)this.xMouse, (float)this.yMouse, (LivingEntity)this.minecraft.player);
    }

    protected boolean isHovering(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        return (!this.widthTooNarrow || !this.recipeBookComponent.isVisible()) && super.isHovering(pX, pY, pWidth, pHeight, pMouseX, pMouseY);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.recipeBookComponent.mouseClicked(pMouseX, pMouseY, pButton)) {
            this.setFocused((GuiEventListener)this.recipeBookComponent);
            return true;
        }
        return this.widthTooNarrow && this.recipeBookComponent.isVisible() ? false : super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (this.buttonClicked) {
            this.buttonClicked = false;
            return true;
        }
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    protected boolean hasClickedOutside(double pMouseX, double pMouseY, int pGuiLeft, int pGuiTop, int pMouseButton) {
        boolean flag = pMouseX < (double)pGuiLeft || pMouseY < (double)pGuiTop || pMouseX >= (double)(pGuiLeft + this.imageWidth) || pMouseY >= (double)(pGuiTop + this.imageHeight);
        return this.recipeBookComponent.hasClickedOutside(pMouseX, pMouseY, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, pMouseButton) && flag;
    }

    protected void slotClicked(Slot pSlot, int pSlotId, int pMouseButton, ClickType pType) {
        super.slotClicked(pSlot, pSlotId, pMouseButton, pType);
        this.recipeBookComponent.slotClicked(pSlot);
    }

    public void recipesUpdated() {
        this.recipeBookComponent.recipesUpdated();
    }

    public RecipeBookComponent getRecipeBookComponent() {
        return this.recipeBookComponent;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (super.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (UnionLib.Modulo.Accessory_Inventory.isActive() && KeyBindings.OPEN_UNION_INVENTORY.isActiveAndMatches(InputConstants.getKey((int)pKeyCode, (int)pScanCode))) {
            this.onClose();
            return true;
        }
        return false;
    }
}

