/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.forge;

import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabBuilder;
import com.stereowalker.unionlib.api.registries.RegistryCollector;
import com.stereowalker.unionlib.api.registries.RegistryWrapper;
import com.stereowalker.unionlib.core.registries.Housing;
import com.stereowalker.unionlib.core.registries.RegistryObject;
import com.stereowalker.unionlib.core.registries.RegistryWrapImpl;
import com.stereowalker.unionlib.insert.ClientInserts;
import com.stereowalker.unionlib.insert.Inserts;
import com.stereowalker.unionlib.insert.ServerInserts;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.ModHandler;
import com.stereowalker.unionlib.network.protocol.game.BasePacket;
import com.stereowalker.unionlib.world.entity.ai.UAttributes;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.simple.SimpleFlow;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.Logger;

public class PlatformHelper {
    @Deprecated
    public static boolean isClientInstance() {
        return FMLEnvironment.dist.isClient();
    }

    @Deprecated
    public static boolean isServerInstance() {
        return FMLEnvironment.dist.isDedicatedServer();
    }

    @Deprecated
    public static boolean isDevEnvironment() {
        return !FMLEnvironment.production;
    }

    public static <T extends BasePacket> SimpleFlow<RegistryFriendlyByteBuf, Object> registerMessage(SimpleFlow<RegistryFriendlyByteBuf, Object> simpleFlow, Class<T> messageType, Function<RegistryFriendlyByteBuf, T> decoder) {
        return simpleFlow.add(messageType, StreamCodec.ofMember(BasePacket::encode, decoder::apply), (packet, context) -> packet.message(() -> context));
    }

    public static void handleEvents() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(ModHandler::registerAllServerRelaodableResources);
        forgeBus.addListener(event -> {
            if (event.getOwner() instanceof BowItem && UnionLib.Modulo.Default_Bow_Draw_Speed.isActive()) {
                event.register(DataComponents.ATTRIBUTE_MODIFIERS, (Object)UnionLib.createBowAttributes((ItemAttributeModifiers)event.getDataComponentMap().get(DataComponents.ATTRIBUTE_MODIFIERS)));
            }
        });
        forgeBus.addListener(event -> {
            if (ModHandler.getLoadState().runsOnServer()) {
                boolean weCrit = false;
                double critRate = event.getEntity().getAttributeValue(UAttributes.CRITICAL_RATE.holder());
                if (critRate > 0.0 && !event.isVanillaCritical()) {
                    Random random = new Random();
                    if (random.nextDouble() < critRate) {
                        weCrit = true;
                        event.setResult(Event.Result.ALLOW);
                    }
                }
                if (event.isVanillaCritical() || weCrit) {
                    event.setDamageModifier((float)event.getEntity().getAttributeValue(UAttributes.CRITICAL_DAMAGE.holder()));
                }
            }
        });
        forgeBus.addListener(evt -> Inserts.PLAYER_ATTACK.insert(evt.getEntity(), evt.getTarget(), c -> {
            if (c.booleanValue()) {
                evt.setCanceled(true);
            }
        }));
        forgeBus.addListener(evt -> Inserts.LIVING_FALL.insert(evt.getEntity(), evt.getDistance(), arg_0 -> ((LivingFallEvent)evt).setDistance(arg_0), evt.getDamageMultiplier(), arg_0 -> ((LivingFallEvent)evt).setDamageMultiplier(arg_0), () -> evt.setCanceled(true)));
        forgeBus.addListener(evt -> Inserts.FOV.insert(evt.getPlayer(), evt.getFovModifier(), evt.getNewFovModifier(), arg_0 -> ((ComputeFovModifierEvent)evt).setNewFovModifier(arg_0)));
        forgeBus.addListener(event -> Inserts.LIVING_ATTACK.insert(event.getEntity(), event.getSource(), event.getAmount()));
        forgeBus.addListener(event -> Inserts.LIVING_DEATH.insert(event.getEntity(), event.getSource()));
        forgeBus.addListener(event -> Inserts.LIVING_HEAL.insert(event.getEntity(), event.getAmount(), arg_0 -> ((LivingHealEvent)event).setAmount(arg_0)));
        forgeBus.addListener(event -> Inserts.ENTITY_JOIN_LEVEL.insert(event.getEntity(), event.getLevel(), event.loadedFromDisk()));
        forgeBus.addListener(event -> Inserts.ITEM_TOOLTIP.insert(event.getItemStack(), event.getEntity(), event.getToolTip(), event.getFlags()));
        forgeBus.addListener(event -> Inserts.FINISH_SLEEP.insert(event.getLevel(), event.getNewTime(), arg_0 -> ((SleepFinishedTimeEvent)event).setTimeAddition(arg_0)));
        forgeBus.addListener(evt -> Inserts.LOOT_TABLE_LOAD.insert(evt.getName(), evt.getTable(), arg_0 -> ((LootTableLoadEvent)evt).setTable(arg_0), () -> evt.setCanceled(true)));
        forgeBus.addListener(event -> Inserts.LEVEL_SAVE.insert(event.getLevel()));
        forgeBus.addListener(event -> Inserts.LEVEL_LOAD.insert(event.getLevel()));
        forgeBus.addListener(event -> Inserts.LIVING_JUMP.insert(event.getEntity()));
        forgeBus.addListener(event -> Inserts.LIVING_TICK.insert(event.getEntity()));
        forgeBus.addListener(event -> Inserts.ITEM_USE_FINISH.insert(event.getEntity(), event.getItem(), event.getDuration(), event.getResultStack(), arg_0 -> ((LivingEntityUseItemEvent.Finish)event).setResultStack(arg_0)));
        forgeBus.addListener(event -> Inserts.MENU_CLOSE.insert(event.getEntity(), event.getContainer()));
        forgeBus.addListener(event -> Inserts.MENU_OPEN.insert(event.getEntity(), event.getContainer()));
        forgeBus.addListener(evt -> Inserts.INTERACT_WITH_ENTITY.insert(evt.getEntity(), evt.getHand(), evt.getTarget(), c -> {
            if (c.booleanValue()) {
                evt.setCanceled(true);
            }
        }, evt.getCancellationResult(), arg_0 -> ((PlayerInteractEvent.EntityInteract)evt).setCancellationResult(arg_0)));
        forgeBus.addListener(evt -> Inserts.INTERACT_WITH_BLOCK.insert(evt.getEntity(), evt.getLevel(), evt.getHand(), evt.getHitVec(), evt.getCancellationResult(), arg_0 -> ((PlayerInteractEvent.RightClickBlock)evt).setCancellationResult(arg_0), () -> evt.setCanceled(true)));
        forgeBus.addListener(evt -> Inserts.INTERACT_WITH_ITEM.insert(evt.getEntity(), evt.getLevel(), evt.getHand(), (InteractionResultHolder<ItemStack>)new InteractionResultHolder(evt.getCancellationResult(), (Object)evt.getItemStack()), cancel -> evt.setCancellationResult(cancel.getResult()), () -> evt.setCanceled(true)));
        forgeBus.addListener(event -> Inserts.PLAYER_RESTORE.insert(event.getEntity(), event.getOriginal(), !event.isWasDeath()));
        forgeBus.addListener(event -> Inserts.LOGGED_OUT.insert(event.getEntity()));
        forgeBus.addListener(event -> Inserts.LOGGED_IN.insert(event.getEntity()));
        forgeBus.addListener(event -> Inserts.XP_PICKUP.insert(event.getEntity(), event.getOrb()));
        forgeBus.addListener(event -> ServerInserts.VILLAGER_TRADES.insert(event.getType(), (Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades(), false));
        forgeBus.addListener(event -> ServerInserts.SERVER_STARTING.insert(event.getServer()));
        forgeBus.addListener(event -> ServerInserts.SERVER_STARTED.insert(event.getServer()));
        forgeBus.addListener(event -> ServerInserts.SERVER_STOPPING.insert(event.getServer()));
        forgeBus.addListener(event -> ServerInserts.SERVER_STOPPED.insert(event.getServer()));
        forgeBus.addListener(event -> {
            if (event.getEntity().isSleeping()) {
                Inserts.PLAYER_CONTINUE_SLEEP.insert(event.getEntity(), (BlockPos)event.getSleepingLocation().get(), event.getResult() == Event.Result.DEFAULT ? event.getEntity().level().isDay() : event.getResult() == Event.Result.ALLOW, set -> event.setResult(set != false ? Event.Result.ALLOW : Event.Result.DENY));
            }
        });
        forgeBus.addListener(event -> Inserts.LEVEL_WAKE_UP.insert(event.getLevel(), event.getNewTime(), arg_0 -> ((SleepFinishedTimeEvent)event).setTimeAddition(arg_0)));
    }

    public static void handleClientEvents() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(evt -> {
            if (evt.phase == TickEvent.Phase.START) {
                ClientInserts.CLIENT_TICK_BEGIN.insert();
            }
            if (evt.phase == TickEvent.Phase.END) {
                ClientInserts.CLIENT_TICK_FINISH.insert();
            }
        });
        forgeBus.addListener(event -> ClientInserts.ITEM_TOOLTIP.insert(event.getItemStack(), event.getEntity(), event.getToolTip(), event.getFlags()));
        forgeBus.addListener(evt -> ClientInserts.SCREEN_RENDER_FINISH.insert(evt.getScreen(), evt.getGuiGraphics(), evt.getMouseX(), evt.getMouseY(), evt.getPartialTick()));
    }

    public static <T> void handleRegistration(MinecraftMod mod, String namespace, Field[] fields, ResourceKey<Registry<T>> registryKey, Logger LOGGER) {
        DeferredRegister ARMOR_MATERIAL = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)namespace);
        DeferredRegister BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)namespace);
        DeferredRegister COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)namespace);
        DeferredRegister ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)namespace);
        DeferredRegister FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)namespace);
        DeferredRegister ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)namespace);
        DeferredRegister POTIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)namespace);
        DeferredRegister MOB_EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)namespace);
        DeferredRegister ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)namespace);
        DeferredRegister SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)namespace);
        DeferredRegister SENSOR_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SENSOR_TYPES, (String)namespace);
        DeferredRegister MENU_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)namespace);
        DeferredRegister PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)namespace);
        for (Field field : fields) {
            net.minecraftforge.registries.RegistryObject val;
            Housing hou;
            if (!field.isAnnotationPresent(RegistryObject.class)) continue;
            RegistryObject regi = field.getAnnotation(RegistryObject.class);
            String regName = regi.value();
            Consumer<Exception> exc = e -> {
                e.printStackTrace();
                LOGGER.warn("There was an error registering " + regName);
            };
            if (registryKey.equals((Object)Registries.BLOCK)) {
                BLOCKS.register(regName, () -> {
                    try {
                        return (Block)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (registryKey.equals((Object)Registries.FLUID)) {
                FLUIDS.register(regName, () -> {
                    try {
                        return (Fluid)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (registryKey.equals((Object)Registries.ENCHANTMENT)) {
                ENCHANTMENTS.register(regName, () -> {
                    try {
                        return (Enchantment)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (registryKey.equals((Object)Registries.ITEM)) {
                ITEMS.register(regName, () -> {
                    try {
                        return (Item)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (registryKey.equals((Object)Registries.ARMOR_MATERIAL)) {
                try {
                    if (!(field.get(null) instanceof Housing)) {
                        throw new UnsupportedOperationException("Please wrap \"" + regName + " in a housing\".");
                    }
                    hou = (Housing)field.get(null);
                    val = ARMOR_MATERIAL.register(regName, hou.value());
                    hou.setHolder(() -> val.getHolder());
                }
                catch (IllegalAccessException | IllegalArgumentException e2) {
                    exc.accept(e2);
                }
                continue;
            }
            if (registryKey.equals((Object)Registries.ATTRIBUTE)) {
                try {
                    if (!(field.get(null) instanceof Housing)) {
                        throw new UnsupportedOperationException("Please wrap \"" + regName + " in a housing\".");
                    }
                    hou = (Housing)field.get(null);
                    val = ATTRIBUTES.register(regName, hou.value());
                    hou.setHolder(() -> val.getHolder());
                }
                catch (IllegalAccessException | IllegalArgumentException e3) {
                    exc.accept(e3);
                }
                continue;
            }
            if (registryKey.equals((Object)Registries.MOB_EFFECT)) {
                try {
                    if (field.get(null) instanceof Housing) {
                        hou = (Housing)field.get(null);
                        val = MOB_EFFECTS.register(regName, hou.value());
                        hou.setHolder(() -> val.getHolder());
                        continue;
                    }
                    MOB_EFFECTS.register(regName, () -> {
                        try {
                            return (MobEffect)field.get(null);
                        }
                        catch (IllegalAccessException | IllegalArgumentException e) {
                            exc.accept(e);
                            return null;
                        }
                    });
                }
                catch (IllegalAccessException | IllegalArgumentException e4) {
                    exc.accept(e4);
                }
                continue;
            }
            if (registryKey.equals((Object)Registries.POTION)) {
                try {
                    if (!(field.get(null) instanceof Housing)) {
                        throw new UnsupportedOperationException("Please wrap \"" + regName + " in a housing\".");
                    }
                    hou = (Housing)field.get(null);
                    val = POTIONS.register(regName, hou.value());
                    hou.setHolder(() -> val.getHolder());
                }
                catch (IllegalAccessException | IllegalArgumentException e5) {
                    exc.accept(e5);
                }
                continue;
            }
            if (registryKey.equals((Object)Registries.RECIPE_SERIALIZER)) {
                SERIALIZERS.register(regName, () -> {
                    try {
                        return (RecipeSerializer)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (registryKey.equals((Object)Registries.DATA_COMPONENT_TYPE)) {
                COMPONENTS.register(regName, () -> {
                    try {
                        return (DataComponentType)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (registryKey.equals((Object)Registries.SENSOR_TYPE)) {
                SENSOR_TYPE.register(regName, () -> {
                    try {
                        return (SensorType)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (registryKey.equals((Object)Registries.MENU)) {
                MENU_TYPE.register(regName, () -> {
                    try {
                        return (MenuType)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (registryKey.equals((Object)Registries.PARTICLE_TYPE)) {
                PARTICLE_TYPES.register(regName, () -> {
                    try {
                        return (ParticleType)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            throw new UnsupportedOperationException("Cannot register \"" + String.valueOf(registryKey) + "'s\" through Needle.");
        }
        if (ModHandler.mods.get(mod.getModid()).eventBus() != null || FMLJavaModLoadingContext.get() != null) {
            IEventBus modEventBus = ModHandler.mods.get(mod.getModid()).eventBus() != null ? ModHandler.mods.get(mod.getModid()).eventBus() : FMLJavaModLoadingContext.get().getModEventBus();
            BLOCKS.register(modEventBus);
            FLUIDS.register(modEventBus);
            ITEMS.register(modEventBus);
            ENCHANTMENTS.register(modEventBus);
            POTIONS.register(modEventBus);
            ARMOR_MATERIAL.register(modEventBus);
            MOB_EFFECTS.register(modEventBus);
            SERIALIZERS.register(modEventBus);
            ATTRIBUTES.register(modEventBus);
            MENU_TYPE.register(modEventBus);
            COMPONENTS.register(modEventBus);
            PARTICLE_TYPES.register(modEventBus);
        }
    }

    public static void doCreativeTabs(MinecraftMod mod) {
        IEventBus modEventBus = ModHandler.mods.get(mod.getModid()).eventBus();
        DeferredRegister CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)mod.getModid());
        CreativeTabBuilder builders = (name, tab) -> {
            if (tab != null) {
                CREATIVE_MODE_TABS.register(name, () -> tab);
            }
        };
        mod.registerCreativeTabs(builders);
        CREATIVE_MODE_TABS.register(modEventBus);
    }

    public static <V> RegistryWrapper<V> createWrappedRegistry(MinecraftMod mod, boolean shouldSync, ResourceKey<Registry<V>> registryKey) {
        RegistryWrapImpl reggie = new RegistryWrapImpl();
        mod.eventBus().addListener(event -> {
            RegistryBuilder builder = new RegistryBuilder().setName(registryKey.location()).setMaxID(0x7FFFFFFE);
            if (!shouldSync) {
                builder = builder.disableSync();
            }
            event.create(builder, forge -> reggie.bind(new RegistryWrapper<V>((IForgeRegistry)forge){
                final /* synthetic */ IForgeRegistry val$forge;
                {
                    this.val$forge = iForgeRegistry;
                }

                @Override
                public Iterator<V> iterator() {
                    return this.val$forge.iterator();
                }

                @Override
                public V get(ResourceLocation key) {
                    return this.val$forge.getValue(key);
                }

                @Override
                public ResourceLocation key(V val) {
                    return this.val$forge.getKey(val);
                }
            }));
        });
        return reggie;
    }

    public static <T> void registerCustom(MinecraftMod mod, ResourceKey<Registry<T>> registry, Consumer<RegistryCollector.Custom<T>> register) {
        mod.eventBus().addListener(event -> event.register(registry, helper -> register.accept(new RegistryCollector.Custom<T>((RegisterEvent.RegisterHelper)helper){
            final /* synthetic */ RegisterEvent.RegisterHelper val$helper;
            {
                this.val$helper = registerHelper;
            }

            @Override
            public void register(ResourceLocation name, T value) {
                this.val$helper.register(name, value);
            }
        })));
    }
}

