/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.hook;

import com.stereowalker.unionlib.world.entity.AccessorySlot;
import com.stereowalker.unionlib.world.item.component.AccessoryAttributeModifiers;
import com.stereowalker.unionlib.world.item.component.UDataComponents;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class AccessoryStackCalls {
    static final UUID BASE_ATTACK_DAMAGE_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    static final UUID BASE_ATTACK_SPEED_UUID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    protected static void gatherAttributes(ItemStack stack, Consumer<Component> pTooltipAdder, @Nullable Player pPlayer, Holder<Attribute> pAttribute, AttributeModifier pModfier) {
        double d0 = pModfier.amount();
        boolean flag = false;
        if (pPlayer != null) {
            if (pModfier.id() == Item.BASE_ATTACK_DAMAGE_UUID) {
                d0 += pPlayer.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                d0 += (double)EnchantmentHelper.getDamageBonus((ItemStack)stack, null);
                flag = true;
            } else if (pModfier.id() == Item.BASE_ATTACK_SPEED_UUID) {
                d0 += pPlayer.getAttributeBaseValue(Attributes.ATTACK_SPEED);
                flag = true;
            }
        }
        double d1 = pModfier.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || pModfier.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? d0 * 100.0 : (pAttribute.is(Attributes.KNOCKBACK_RESISTANCE) ? d0 * 10.0 : d0);
        if (flag) {
            pTooltipAdder.accept((Component)CommonComponents.space().append((Component)Component.translatable((String)("attribute.modifier.equals." + pModfier.operation().id()), (Object[])new Object[]{AccessoryAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable((String)((Attribute)pAttribute.value()).getDescriptionId())})).withStyle(ChatFormatting.DARK_GREEN));
        } else if (d0 > 0.0) {
            pTooltipAdder.accept((Component)Component.translatable((String)("attribute.modifier.plus." + pModfier.operation().id()), (Object[])new Object[]{AccessoryAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable((String)((Attribute)pAttribute.value()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
        } else if (d0 < 0.0) {
            pTooltipAdder.accept((Component)Component.translatable((String)("attribute.modifier.take." + pModfier.operation().id()), (Object[])new Object[]{AccessoryAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(-d1), Component.translatable((String)((Attribute)pAttribute.value()).getDescriptionId())}).withStyle(ChatFormatting.RED));
        }
    }

    public static void forEachModifier(ItemStack stack, AccessorySlot pEquipmentSLot, BiConsumer<Holder<Attribute>, AttributeModifier> pAction) {
        AccessoryAttributeModifiers itemattributemodifiers = (AccessoryAttributeModifiers)stack.getOrDefault(UDataComponents.ATTRIBUTE_MODIFIERS, (Object)AccessoryAttributeModifiers.EMPTY);
        if (!itemattributemodifiers.modifiers().isEmpty()) {
            itemattributemodifiers.forEach(pEquipmentSLot, pAction);
        } else {
            AccessoryAttributeModifiers.EMPTY.forEach(pEquipmentSLot, pAction);
        }
    }
}

