/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.stereowalker.unionlib.UnionLibClientSegment;
import com.stereowalker.unionlib.api.collectors.ConfigCollector;
import com.stereowalker.unionlib.api.collectors.DefaultAttributeModifier;
import com.stereowalker.unionlib.api.collectors.InsertCollector;
import com.stereowalker.unionlib.api.collectors.PacketCollector;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabPopulator;
import com.stereowalker.unionlib.api.keymaps.KeyMappingCollector;
import com.stereowalker.unionlib.api.registries.RegistryCollector;
import com.stereowalker.unionlib.client.gui.screens.config.ConfigScreen;
import com.stereowalker.unionlib.client.gui.screens.config.MinecraftModConfigsScreen;
import com.stereowalker.unionlib.config.Config;
import com.stereowalker.unionlib.config.ConfigBuilder;
import com.stereowalker.unionlib.config.ServerConfig;
import com.stereowalker.unionlib.config.tests.TestBindClass1Config;
import com.stereowalker.unionlib.config.tests.TestBindClass2Config;
import com.stereowalker.unionlib.config.tests.TestClassConfig;
import com.stereowalker.unionlib.config.tests.TestObjectConfig;
import com.stereowalker.unionlib.forge.PlatformHelper;
import com.stereowalker.unionlib.insert.Inserts;
import com.stereowalker.unionlib.mod.ClientSegment;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.ModHandler;
import com.stereowalker.unionlib.mod.PacketHolder;
import com.stereowalker.unionlib.mod.ServerSegment;
import com.stereowalker.unionlib.network.protocol.game.ClientboundConfigPacket;
import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionInventoryPacket;
import com.stereowalker.unionlib.supporter.Cosmetics;
import com.stereowalker.unionlib.supporter.Supporters;
import com.stereowalker.unionlib.util.NeedleUUIDs;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.entity.ai.UAttributes;
import com.stereowalker.unionlib.world.inventory.UMenuType;
import com.stereowalker.unionlib.world.item.UItems;
import com.stereowalker.unionlib.world.item.component.UDataComponents;
import com.stereowalker.unionlib.world.item.crafting.URecipeSerializer;
import java.io.File;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="unionlib")
public class UnionLib
extends MinecraftMod
implements PacketHolder {
    public static UnionLib instance;
    public static TestObjectConfig test_config;
    public static final Config CONFIG;
    public static final ServerConfig SERVER_CONFIG;
    public static final String MOD_ID = "unionlib";
    public static final Logger LOGGER;
    public static final String INVENTORY_KEY = "UnionInventory";

    public static void debug(Object message, boolean ignoreConfig) {
        if (UnionLib.CONFIG.debug || ignoreConfig) {
            LOGGER.info(message);
        }
    }

    public static void debug(Object message) {
        UnionLib.debug(message, false);
    }

    public static void warn(String message) {
        if (UnionLib.CONFIG.debug) {
            LOGGER.warn(message);
        }
    }

    public static boolean disableConfig() {
        return false;
    }

    public UnionLib() {
        super(MOD_ID, () -> new UnionLibClientSegment(), () -> new ServerSegment());
        instance = this;
    }

    @Override
    public void onModConstruct() {
        new MinecraftMod(this, "concept_class", () -> new ClientSegment(){

            @Override
            public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
                return new ConfigScreen(previousScreen, TestClassConfig.class, (Component)Component.translatable((String)"Test Config 1"));
            }

            @Override
            public ResourceLocation getModIcon() {
                return UnionLib.this.location("textures/gui/test_1.png");
            }
        }, null, PlatformHelper.isDevEnvironment()){

            @Override
            public void setupConfigs(ConfigCollector collector) {
                collector.registerConfig(TestClassConfig.class);
            }
        };
        new MinecraftMod(this, "concept_object", () -> new ClientSegment(){

            @Override
            public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
                return new ConfigScreen(previousScreen, test_config, (Component)Component.translatable((String)"Test Config 2"));
            }

            @Override
            public ResourceLocation getModIcon() {
                return UnionLib.this.location("textures/gui/test_2.png");
            }
        }, null, PlatformHelper.isDevEnvironment()){

            @Override
            public void setupConfigs(ConfigCollector collector) {
                collector.registerConfig(test_config);
            }
        };
        new MinecraftMod(this, "concept_combined_config", () -> new ClientSegment(){

            @Override
            public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
                return new MinecraftModConfigsScreen(previousScreen, (Component)Component.translatable((String)"Test Config 3"), TestBindClass1Config.class, TestBindClass2Config.class);
            }

            @Override
            public ResourceLocation getModIcon() {
                return UnionLib.this.location("textures/gui/test_3.png");
            }
        }, null, PlatformHelper.isDevEnvironment()){

            @Override
            public void setupConfigs(ConfigCollector collector) {
                collector.registerConfig(TestBindClass1Config.class);
                collector.registerConfig(TestBindClass2Config.class);
            }
        };
        new MinecraftMod("concept_keys", () -> new ClientSegment(){

            @Override
            public void setupKeymappings(KeyMappingCollector collector) {
                collector.addKeyMapping(new KeyMapping("key.unionlib.test_bind", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 86, "DAD"));
            }

            @Override
            public ResourceLocation getModIcon() {
                return UnionLib.this.location("textures/gui/test_4.png");
            }
        }, null, PlatformHelper.isDevEnvironment());
    }

    @Override
    public void onModStartup() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        PlatformHelper.handleEvents();
    }

    @Override
    public void onModStartupInClient() {
        PlatformHelper.handleClientEvents();
        Cosmetics.obtainCosmetics(new File(Minecraft.getInstance().gameDirectory, "ucache.db"), true);
        Supporters.populateSupporters(new File(Minecraft.getInstance().gameDirectory, "supportercache.json"), true);
    }

    @Override
    public void setupConfigs(ConfigCollector collector) {
        collector.registerConfig(CONFIG);
        collector.registerConfig(SERVER_CONFIG);
    }

    @Override
    public void registerPackets(PacketCollector collector) {
        collector.registerClientboundPacket(ClientboundConfigPacket.id, ClientboundConfigPacket.class, packetBuffer -> new ClientboundConfigPacket((RegistryFriendlyByteBuf)packetBuffer));
        collector.registerServerboundPacket(ServerboundUnionInventoryPacket.id, ServerboundUnionInventoryPacket.class, packetBuffer -> new ServerboundUnionInventoryPacket((RegistryFriendlyByteBuf)packetBuffer));
    }

    @Override
    public void registerInserts(InsertCollector collector) {
        collector.addInsert(Inserts.LOGGED_IN, x -> ConfigBuilder.sendConfigValues((ServerPlayer)x));
    }

    @Override
    public void populateCreativeTabs(CreativeTabPopulator builder) {
        if (builder.isToolTab()) {
            builder.addItems(Lists.newArrayList((Object[])new Item[]{UItems.GOLDEN_RING, UItems.IRON_EMERALD_NECKALCE}));
        }
    }

    @Override
    public void setupRegistries(RegistryCollector collector) {
        collector.addRegistryHolder(Registries.ATTRIBUTE, UAttributes.class);
        collector.addRegistryHolder(Registries.ITEM, UItems.class);
        collector.addRegistryHolder(Registries.MENU, UMenuType.class);
        collector.addRegistryHolder(Registries.RECIPE_SERIALIZER, URecipeSerializer.class);
        collector.addRegistryHolder(Registries.DATA_COMPONENT_TYPE, UDataComponents.class);
    }

    @Override
    public void modifyDefaultEntityAttributes(DefaultAttributeModifier modifier) {
        for (EntityType l : BuiltInRegistries.ENTITY_TYPE) {
            if (!l.getBaseClass().isAssignableFrom(LivingEntity.class)) continue;
            modifier.addToEntity((EntityType<? extends LivingEntity>)l, UAttributes.DRAW_SPEED.holder());
        }
        modifier.addToEntity((EntityType<? extends LivingEntity>)EntityType.PLAYER, UAttributes.CRITICAL_DAMAGE.holder(), UAttributes.CRITICAL_RATE.holder(), UAttributes.ACCURACY.holder(), UAttributes.ARROW_VELOCITY.holder(), UAttributes.ARROW_DAMAGE.holder());
        double draw = Modulo.Default_Bow_Draw_Speed.isActive() ? 4.0 : 1.0;
        modifier.addToEntityWithValues((EntityType<? extends LivingEntity>)EntityType.SKELETON, UAttributes.DRAW_SPEED.holder(), draw);
        modifier.addToEntityWithValues((EntityType<? extends LivingEntity>)EntityType.PLAYER, UAttributes.DRAW_SPEED.holder(), draw);
        modifier.addToEntityWithValues((EntityType<? extends LivingEntity>)EntityType.STRAY, Lists.newArrayList((Object[])new Tuple[]{new Tuple(UAttributes.DRAW_SPEED.holder(), (Object)draw)}));
    }

    public static ItemAttributeModifiers createBowAttributes(ItemAttributeModifiers old) {
        if (ModHandler.getLoadState().runsOnBothSides()) {
            return ItemAttributeModifiers.builder().add(UAttributes.DRAW_SPEED.holder(), new AttributeModifier(NeedleUUIDs.BASE_DRAW_SPEED_UUID, -3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND).build();
        }
        return old;
    }

    static {
        test_config = new TestObjectConfig();
        CONFIG = new Config();
        SERVER_CONFIG = new ServerConfig();
        LOGGER = LogManager.getLogger((String)MOD_ID);
    }

    public static enum Modulo {
        Accessory_Inventory,
        Default_Bow_Draw_Speed;

        private boolean isEnabled = false;

        public void enable() {
            this.isEnabled = true;
        }

        public void disable() {
            this.isEnabled = false;
        }

        public boolean isActive() {
            return this.isEnabled;
        }
    }

    public static class Locations {
        public static final ResourceLocation Serverbound_union_inventory_packet = VersionHelper.toLoc("unionlib", "serverbound_union_inventory_packet");
        public static final ResourceLocation UNION_BUTTON_IMAGE = VersionHelper.toLoc("unionlib", "textures/gui/union_button.png");
        public static final ResourceLocation OVERLAY_BUTTON_IMAGE_BACKGROUND = VersionHelper.toLoc("unionlib", "textures/gui/button_background.png");
        public static final ResourceLocation EMPTY_ACCESSORY_SLOT_NECKLACE = VersionHelper.toLoc("unionlib", "item/empty_accessory_slot_necklace");
        public static final ResourceLocation EMPTY_ACCESSORY_SLOT_BACK = VersionHelper.toLoc("unionlib", "item/empty_accessory_slot_back");
        public static final ResourceLocation EMPTY_ACCESSORY_SLOT_RING = VersionHelper.toLoc("unionlib", "item/empty_accessory_slot_ring");
        public static final ResourceLocation UNION_INVENTORY_BACKGROUND = VersionHelper.toLoc("unionlib", "textures/gui/container/union_inventory.png");
    }

    @Deprecated
    public static class Modules {
        public static boolean isAccessoryInventoryEnabled() {
            return Modulo.Accessory_Inventory.isActive();
        }

        public static void enableAccessoryInventory() {
            Modulo.Accessory_Inventory.enable();
        }

        public static void disableAccessoryInventory() {
            Modulo.Accessory_Inventory.disable();
        }

        public static boolean isDefaultDrawSpeedAppliedToBows() {
            return Modulo.Default_Bow_Draw_Speed.isActive();
        }

        public static void removeDefaultDrawSpeedToBows() {
            Modulo.Default_Bow_Draw_Speed.disable();
        }
    }
}

