/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib;

import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.api.collectors.InsertCollector;
import com.stereowalker.unionlib.api.collectors.MenuCollector;
import com.stereowalker.unionlib.api.keymaps.KeyMappingCollector;
import com.stereowalker.unionlib.client.gui.screens.config.ConfigScreen;
import com.stereowalker.unionlib.client.gui.screens.inventory.UnionInventoryScreen;
import com.stereowalker.unionlib.client.keybindings.KeyBindings;
import com.stereowalker.unionlib.client.model.HatModel;
import com.stereowalker.unionlib.insert.ClientInserts;
import com.stereowalker.unionlib.mod.ClientSegment;
import com.stereowalker.unionlib.mod.ModHandler;
import com.stereowalker.unionlib.supporter.Cosmetic;
import com.stereowalker.unionlib.supporter.CosmeticHandler;
import com.stereowalker.unionlib.supporter.Cosmetics;
import com.stereowalker.unionlib.world.inventory.UMenuType;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;

public class UnionLibClientSegment
extends ClientSegment {
    private Map<LivingEntityRenderer<?, ?>, HatModel<?>> cosmetics = new WeakHashMap();

    @Override
    public void initClientAfterMinecraft(Minecraft mc) {
        new Cosmetics(mc);
    }

    @Override
    public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
        return new ConfigScreen(previousScreen, UnionLib.CONFIG, (Component)Component.translatable((String)"UnionLib Config"));
    }

    @Override
    public void setupKeymappings(KeyMappingCollector collector) {
        collector.addKeyMapping(KeyBindings.OPEN_UNION_INVENTORY);
    }

    @Override
    public void registerInserts(InsertCollector collector) {
        collector.addInsert(ClientInserts.CLIENT_TICK_BEGIN, () -> {
            if (Minecraft.getInstance().level != null && Minecraft.getInstance().level.players().size() > 1) {
                Cosmetics.pollCosmetics();
            }
        });
        collector.addInsert(ClientInserts.ITEM_TOOLTIP, (stack, player, tip, flag) -> {
            if (flag.isAdvanced() && UnionLib.CONFIG.tags) {
                ArrayList tags = new ArrayList();
                stack.getTags().forEach(tag -> tags.add(Component.literal((String)("#" + String.valueOf(tag.location()))).withColor(UnionLib.CONFIG.tagColor)));
                if (stack.getComponents().size() > 0) {
                    tip.addAll(tip.size() - 1, tags);
                } else {
                    tip.addAll(tags);
                }
            }
        });
        collector.addInsert(ClientInserts.LIVING_RENDER_FINISH, (entity, renderer, entityYaw, partialTicks, poseStack, buffer, packedLight) -> {
            AbstractClientPlayer player;
            if (entity instanceof AbstractClientPlayer && CosmeticHandler.doesPlayerNeedCosmetic((Player)(player = (AbstractClientPlayer)entity))) {
                HatModel<?> hatmodel;
                Cosmetic hat = CosmeticHandler.getHat((Player)player);
                if (!this.cosmetics.containsKey(renderer) || hat != this.cosmetics.get(renderer).getHat()) {
                    this.cosmetics.put(renderer, new HatModel(hat));
                }
                if ((hatmodel = this.cosmetics.get(renderer)).getHat().texture() != null && (hatmodel.getHat().showOnHelmet() || player.getItemBySlot(EquipmentSlot.HEAD).isEmpty())) {
                    poseStack.pushPose();
                    CosmeticHandler.setupPose(renderer, player, entityYaw, partialTicks, poseStack, buffer, packedLight);
                    CosmeticHandler.addCosmetic(renderer, player, poseStack, buffer, hatmodel, packedLight, partialTicks, (HumanoidModel)renderer.getModel());
                    poseStack.popPose();
                }
            }
        });
    }

    @Override
    public ResourceLocation getModIcon() {
        return UnionLib.Locations.UNION_BUTTON_IMAGE;
    }

    @Override
    public void setupMenus(MenuCollector collector) {
        if (!ModHandler.getLoadState().runsOnlyOnClient()) {
            collector.addMenu(UMenuType.UNION, UnionInventoryScreen::new);
        }
    }
}

