/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.components;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.stereowalker.unionlib.client.model.HatModel;
import com.stereowalker.unionlib.supporter.Cosmetic;
import com.stereowalker.unionlib.supporter.Cosmetics;
import com.stereowalker.unionlib.util.VersionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class CosmeticButton
extends Button {
    HatModel<Player> hat;
    PlayerModel<Player> playerModel;
    boolean darken;

    public CosmeticButton(int pX, int pY, int pWidth, int pHeight, Cosmetic model, Button.OnPress pOnPress) {
        super(pX, pY, pWidth, pHeight, (Component)Component.empty(), pOnPress, Button.DEFAULT_NARRATION);
        Minecraft minecraft = Minecraft.getInstance();
        this.hat = new HatModel(model);
        this.playerModel = new PlayerModel(minecraft.getEntityModels().bakeLayer(ModelLayers.PLAYER), false);
        this.playerModel.young = false;
        this.playerModel.head.y = 24.0f;
        this.hat.attach((HumanoidModel<Player>)this.playerModel);
    }

    public boolean isCosmetic(Cosmetic model) {
        return this.hat.getHat() == model;
    }

    public void update(boolean isEquipped, boolean isOwned) {
        this.active = !isEquipped;
        this.darken = !isOwned;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTicks) {
        float r = this.darken ? 1.0f : 0.9f;
        float g = this.darken ? 0.7f : 1.0f;
        float b = this.darken ? 0.7f : 0.9f;
        float c = this.darken ? 0.8f : 1.0f;
        guiGraphics.setColor(r, g, b, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        guiGraphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        guiGraphics.setColor(c, c, c, this.alpha);
        float height = (float)this.getHeight() - 6.0f;
        float width = (float)this.getWidth() - 6.0f;
        float x = (float)this.getX() + 3.0f;
        float y = (float)this.getY() + 6.0f;
        float rotationX = ((float)mouseY / (float)guiGraphics.guiHeight() * 2.0f - 1.0f) * 11.0f;
        float rotationY = ((float)mouseX / (float)guiGraphics.guiWidth() * 2.0f - 1.0f) * -50.0f;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(x + width / 2.0f, y + height, 100.0f);
        float f = height / 2.125f;
        f = height / ((8.5f + (float)this.hat.centerHead()) / 16.0f);
        guiGraphics.pose().scale(f, f, f);
        guiGraphics.pose().translate(0.0f, -0.0625f, 0.0f);
        guiGraphics.pose().rotateAround(Axis.XP.rotationDegrees(rotationX), 0.0f, -1.0625f, 0.0f);
        guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(rotationY));
        guiGraphics.flush();
        VersionHelper.setupForEntityInInventory(Axis.XP.rotationDegrees(rotationX));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(1.0f, 1.0f, -1.0f);
        guiGraphics.pose().translate(0.0f, -1.5f, 0.0f);
        VertexConsumer vertexConsumer = guiGraphics.bufferSource().getBuffer(RenderType.entityTranslucent((ResourceLocation)VersionHelper.toLoc("unionlib", "textures/cosmetics/head_preview.png")));
        this.playerModel.renderToBuffer(guiGraphics.pose(), vertexConsumer, 0xF000F0, OverlayTexture.NO_OVERLAY);
        if (!Cosmetics.isEmpty(this.hat.getHat())) {
            VertexConsumer vertexConsumer2 = guiGraphics.bufferSource().getBuffer(RenderType.entityTranslucent((ResourceLocation)this.hat.getHat().texture()));
            this.hat.renderToBuffer(guiGraphics.pose(), vertexConsumer2, 0xF000F0, OverlayTexture.NO_OVERLAY);
        }
        guiGraphics.pose().popPose();
        guiGraphics.flush();
        Lighting.setupFor3DItems();
        guiGraphics.pose().popPose();
    }
}

