/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.screens;

import com.stereowalker.unionlib.api.gui.GuiRenderer;
import com.stereowalker.unionlib.client.gui.screens.DefaultScreen;
import com.stereowalker.unionlib.client.gui.screens.controls.ModControlsScreen;
import com.stereowalker.unionlib.mod.ClientSegment;
import com.stereowalker.unionlib.util.ScreenHelper;
import java.util.ArrayList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.commons.compress.utils.Lists;

public class ModConfigurationScreen
extends DefaultScreen {
    private Button configButton;
    private Button keyButton;
    private ClientSegment mod;

    public ModConfigurationScreen(ClientSegment mod, Screen screen) {
        super((Component)Component.translatable((String)"unionlib.setup.title"), screen);
        this.mod = mod;
    }

    @Override
    protected void initialize() {
        ArrayList keys = Lists.newArrayList();
        this.mod.setupKeymappings(keys::add);
        GridLayout gridlayout = new GridLayout();
        gridlayout.defaultCellSetting().paddingHorizontal(4).alignVerticallyMiddle().paddingBottom(4).alignHorizontallyCenter();
        GridLayout.RowHelper gridlayout$rowhelper = gridlayout.createRowHelper(2);
        this.configButton = (Button)gridlayout$rowhelper.addChild((LayoutElement)ScreenHelper.buttonBuilder((Component)Component.translatable((String)"union.gui.config"), onPress -> {
            if (this.mod.getConfigScreen(this.minecraft, this) != null) {
                this.minecraft.setScreen(this.mod.getConfigScreen(this.minecraft, this));
            }
        }).bounds(this.width / 2 - 155, this.height / 6 + 48 - 6, 150, 20).build());
        this.configButton.active = this.mod.getConfigScreen(this.minecraft, this) != null;
        this.keyButton = (Button)gridlayout$rowhelper.addChild((LayoutElement)ScreenHelper.buttonBuilder((Component)Component.translatable((String)"union.gui.controls"), onPress -> {
            if (keys.size() > 0) {
                this.minecraft.setScreen((Screen)new ModControlsScreen(this.mod, this, this.minecraft.options));
            }
        }).bounds(this.width / 2 + 5, this.height / 6 + 48 - 6, 150, 20).build());
        this.keyButton.active = keys.size() > 0;
        this.layout.addToContents((LayoutElement)gridlayout);
    }

    @Override
    public void drawOnScreen(GuiRenderer guiRenderer, int mouseX, int mouseY) {
    }
}

