/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.screens.cosmetics;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.stereowalker.unionlib.api.gui.GuiRenderer;
import com.stereowalker.unionlib.client.gui.components.CosmeticButton;
import com.stereowalker.unionlib.client.gui.screens.DefaultScreen;
import com.stereowalker.unionlib.client.gui.screens.cosmetics.CosmeticList;
import com.stereowalker.unionlib.client.model.HatModel;
import com.stereowalker.unionlib.supporter.Cosmetic;
import com.stereowalker.unionlib.supporter.CosmeticHandler;
import com.stereowalker.unionlib.supporter.Cosmetics;
import com.stereowalker.unionlib.util.ScreenHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.PlayerModelPart;

public class CosmeticsScreen
extends DefaultScreen {
    Cosmetic initialHeadwear;
    Cosmetic currentHeadwear;
    protected Map<Cosmetic, CosmeticButton> buttons = new HashMap<Cosmetic, CosmeticButton>();
    CosmeticList list;
    protected UUID currentUser = Minecraft.getInstance().getGameProfile().getId();
    Button saveAndClose;

    public CosmeticsScreen(Screen screen) {
        super((Component)Component.translatable((String)"Cosmetics"), screen);
        this.currentHeadwear = this.initialHeadwear = CosmeticHandler.getHat(this.currentUser);
        Cosmetics.fetchOwnedCosmetics(this.currentUser, () -> this.list.createButtons());
    }

    @Override
    protected void initialize() {
        this.saveAndClose = ScreenHelper.buttonBuilder(CommonComponents.GUI_DONE, p_325377_ -> {
            if (this.initialHeadwear != this.currentHeadwear && Cosmetics.updateCosmetic(Minecraft.getInstance().getGameProfile().getId(), this.currentHeadwear.id())) {
                Cosmetics.obtainCosmetics(new File(this.minecraft.gameDirectory, "ucache.db"), false);
            }
            this.onClose();
        }).build();
        this.list = (CosmeticList)this.addRenderableWidget((GuiEventListener)new CosmeticList(this.minecraft, this));
    }

    @Override
    public void drawOnScreen(GuiRenderer guiRenderer, int mouseX, int mouseY) {
        this.saveAndClose.active = Cosmetics.ownsCosmetic(this.currentHeadwear) && this.initialHeadwear != this.currentHeadwear;
        float x = 100.0f;
        float y = 150.0f;
        float width = 85.0f;
        float height = 120.0f;
        float rotationX = ((float)mouseY / (float)guiRenderer.guiGraphics().guiHeight() * 2.0f - 1.0f) * 11.0f;
        float rotationY = ((float)mouseX / (float)guiRenderer.guiGraphics().guiWidth() * 2.0f - 1.0f) * -50.0f;
        guiRenderer.poseStack().pushPose();
        guiRenderer.poseStack().translate(x, y, 100.0f);
        float f = height / 2.125f;
        guiRenderer.poseStack().scale(f, f, f);
        guiRenderer.poseStack().translate(0.0f, -0.0625f, 0.0f);
        guiRenderer.poseStack().rotateAround(Axis.XP.rotationDegrees(rotationX), 0.0f, -1.0625f, 0.0f);
        guiRenderer.poseStack().mulPose(Axis.YP.rotationDegrees(rotationY));
        guiRenderer.guiGraphics().flush();
        VersionHelper.setupForEntityInInventory(Axis.XP.rotationDegrees(rotationX));
        PlayerSkin skin = Minecraft.getInstance().getSkinManager().getInsecureSkin(Minecraft.getInstance().getGameProfile());
        PlayerModel playermodel = new PlayerModel(this.minecraft.getEntityModels().bakeLayer(ModelLayers.PLAYER), skin.model() == PlayerSkin.Model.SLIM);
        playermodel.setAllVisible(true);
        playermodel.young = false;
        playermodel.hat.visible = this.minecraft.options.isModelPartEnabled(PlayerModelPart.HAT);
        playermodel.jacket.visible = this.minecraft.options.isModelPartEnabled(PlayerModelPart.JACKET);
        playermodel.leftPants.visible = this.minecraft.options.isModelPartEnabled(PlayerModelPart.LEFT_PANTS_LEG);
        playermodel.rightPants.visible = this.minecraft.options.isModelPartEnabled(PlayerModelPart.RIGHT_PANTS_LEG);
        playermodel.leftSleeve.visible = this.minecraft.options.isModelPartEnabled(PlayerModelPart.LEFT_SLEEVE);
        playermodel.rightSleeve.visible = this.minecraft.options.isModelPartEnabled(PlayerModelPart.RIGHT_SLEEVE);
        HatModel hat = new HatModel(this.currentHeadwear);
        hat.attach(playermodel);
        guiRenderer.poseStack().pushPose();
        guiRenderer.poseStack().scale(1.0f, 1.0f, -1.0f);
        guiRenderer.poseStack().translate(0.0f, -1.5f, 0.0f);
        VertexConsumer vertexConsumer = guiRenderer.guiGraphics().bufferSource().getBuffer(RenderType.entityTranslucent((ResourceLocation)skin.texture()));
        playermodel.renderToBuffer(guiRenderer.poseStack(), vertexConsumer, 0xF000F0, OverlayTexture.NO_OVERLAY);
        if (!Cosmetics.isEmpty(this.currentHeadwear)) {
            VertexConsumer vertexConsumer2 = guiRenderer.guiGraphics().bufferSource().getBuffer(RenderType.entityTranslucent((ResourceLocation)hat.getHat().texture()));
            hat.renderToBuffer(guiRenderer.poseStack(), vertexConsumer2, 0xF000F0, OverlayTexture.NO_OVERLAY);
        }
        guiRenderer.poseStack().popPose();
        guiRenderer.guiGraphics().flush();
        Lighting.setupFor3DItems();
        guiRenderer.poseStack().popPose();
    }

    @Override
    protected void addFooter() {
        LinearLayout linearlayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        linearlayout.addChild((LayoutElement)ScreenHelper.buttonBuilder((Component)Component.literal((String)"Cancel"), p_325377_ -> this.onClose()).build());
        linearlayout.addChild((LayoutElement)this.saveAndClose);
    }

    @Override
    protected void repositionElements() {
        this.layout.arrangeElements();
        this.list.updateSize(this.width, this.layout);
    }

    public void removeChild(GuiEventListener e) {
        this.removeWidget(e);
    }

    public <T extends GuiEventListener & NarratableEntry> T addChild(T e) {
        return (T)this.addWidget(e);
    }
}

