/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.config;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.config.CommentedEnum;
import com.stereowalker.unionlib.config.ConfigClassBuilder;
import com.stereowalker.unionlib.config.ConfigHolder;
import com.stereowalker.unionlib.config.ConfigObject;
import com.stereowalker.unionlib.config.ConfigObjectBuilder;
import com.stereowalker.unionlib.config.ConfigSide;
import com.stereowalker.unionlib.config.UnionConfig;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.network.protocol.game.ClientboundConfigPacket;
import com.stereowalker.unionlib.util.Executor;
import com.stereowalker.unionlib.util.LoaderHelper;
import com.stereowalker.unionlib.util.toml.TomlWatcher;
import com.stereowalker.unionlib.util.toml.TomlWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerPlayer;
import org.tomlj.Toml;
import org.tomlj.TomlParseResult;

public class ConfigBuilder {
    public static DedicatedServer currentDedicatedServerInstance = null;
    static Map<String, ConfigHolder<?>> client_values = new HashMap();
    static Map<String, ConfigHolder<?>> common_values = new HashMap();
    static Map<String, ConfigHolder<?>> server_values = new HashMap();
    static Map<String, String> shared_changes = new HashMap<String, String>();
    static Map<String, String> shared_starter = new HashMap<String, String>();
    private static List<String> modidList = Lists.newArrayList();
    static Map<String, TomlWatcher> watcher = new HashMap<String, TomlWatcher>();
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void read(Class<?> classs, Object object, Map<String, String> net, ConfigSide ... readOnly) {
        ArrayList sides = Lists.newArrayList((Object[])readOnly);
        if (classs.isAnnotationPresent(UnionConfig.class)) {
            UnionConfig config = classs.getAnnotation(UnionConfig.class);
            ArrayList<TomlWriter> corrections = new ArrayList<TomlWriter>();
            for (Field field : classs.getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null || readOnly.length != 0 && !sides.contains((Object)configEntry.side())) continue;
                try {
                    ConfigHolder holder;
                    block8: {
                        if (net != null) {
                            String newValue = "";
                            if (!net.containsKey(config.name() + "=" + ConfigBuilder.configName(configEntry))) continue;
                            newValue = net.get(config.name() + "=" + ConfigBuilder.configName(configEntry));
                            holder = common_values.getOrDefault(config.name() + "=" + ConfigBuilder.configName(configEntry), null);
                            if (holder != null) {
                                ConfigBuilder.updateSharedValues(holder, newValue);
                                break block8;
                            } else {
                                System.err.println("No holder was found for " + config.name() + "=" + ConfigBuilder.configName(configEntry));
                                continue;
                            }
                        }
                        holder = ConfigBuilder.getConfigValue(config, configEntry, corrections);
                    }
                    if (holder.get() instanceof Double && field.get(object) instanceof Float) {
                        field.set(object, Float.valueOf(((Double)holder.get()).floatValue()));
                        continue;
                    }
                    field.set(object, holder.get());
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            corrections.forEach(TomlWriter::buildToFile);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static void init(Class<?> classs, Object object, Init server, Init common, Init client, Executor d) {
        UnionConfig config = classs.getAnnotation(UnionConfig.class);
        for (Field field : classs.getFields()) {
            UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
            if (configEntry == null) continue;
            ConfigSide side = configEntry.side() != null ? configEntry.side() : ConfigSide.Shared;
            List<ConfigHolder<?>> holders = common.holders;
            TomlWriter writer = common.writer;
            String filename = common.filename;
            if (side == ConfigSide.Client) {
                writer = client.writer;
                holders = client.holders;
                filename = client.filename;
            } else if (side == ConfigSide.Server) {
                writer = server.writer;
                holders = server.holders;
                filename = server.filename;
            } else {
                writer = common.writer;
                holders = common.holders;
                filename = common.filename;
            }
            try {
                void var25_26;
                boolean useSlider = false;
                String name = "";
                Object enumComment = "";
                if (field.get(object) instanceof CommentedEnum && field.get(object) instanceof Enum) {
                    enumComment = ((CommentedEnum)field.get(object)).getConfigComment();
                }
                enumComment = (String)enumComment + "\n";
                String j = "\n###########################################";
                String k = "\n-------------------------------------------";
                String h = j + "\n";
                Object comment = "";
                ArrayList<Component> saved_comment = new ArrayList<Component>();
                String[] translatableComments = new String[]{};
                if (field.isAnnotationPresent(UnionConfig.Comment.class)) {
                    void var25_28;
                    String string = field.getAnnotation(UnionConfig.Comment.class).comment()[0];
                    translatableComments = field.getAnnotation(UnionConfig.Comment.class).translatable();
                    if (field.getAnnotation(UnionConfig.Comment.class).comment().length > 1) {
                        for (int i = 1; i < field.getAnnotation(UnionConfig.Comment.class).comment().length; ++i) {
                            String string2 = (String)var25_28 + "\n" + field.getAnnotation(UnionConfig.Comment.class).comment()[i];
                        }
                    }
                    comment = h + (String)var25_28 + k + (String)enumComment + "Default: " + String.valueOf(field.get(object)) + k;
                    for (String s : var25_28.split("\n")) {
                        saved_comment.add((Component)Component.literal((String)s).withStyle(ChatFormatting.AQUA));
                    }
                    String[] i = ((String)enumComment).split("\n");
                    int n = i.length;
                    for (int i2 = 0; i2 < n; ++i2) {
                        String s;
                        s = i[i2];
                        saved_comment.add((Component)Component.literal((String)s).withStyle(ChatFormatting.YELLOW));
                    }
                    saved_comment.add((Component)Component.translatable((String)"config.default", (Object[])new Object[]{field.get(object).toString()}).withStyle(ChatFormatting.GREEN));
                } else {
                    comment = h + (String)enumComment + "Default: " + String.valueOf(field.get(object)) + k;
                    for (String s : ((String)enumComment).split("\n")) {
                        saved_comment.add((Component)Component.literal((String)s).withStyle(ChatFormatting.YELLOW));
                    }
                    saved_comment.add((Component)Component.translatable((String)"config.default", (Object[])new Object[]{field.get(object).toString()}).withStyle(ChatFormatting.GREEN));
                }
                Double d2 = 0.0;
                Number max = 0.0;
                if (field.get(object) instanceof Boolean) {
                    name = ConfigBuilder.configName(configEntry, "Boolean");
                    writer.put(name, field.get(object), (String)comment);
                } else if (field.get(object) instanceof Enum) {
                    Enum defaultValue = (Enum)field.get(object);
                    List<Enum> acceptableValues = Arrays.asList((Enum[])defaultValue.getDeclaringClass().getEnumConstants());
                    name = ConfigBuilder.configName(configEntry, "Enum");
                    writer.putEnum(name, Enum.valueOf(defaultValue.getDeclaringClass(), defaultValue.name()), (String)comment);
                } else if (field.get(object) instanceof String) {
                    name = ConfigBuilder.configName(configEntry, "String");
                    writer.put(name, field.get(object), (String)comment);
                } else if (field.isAnnotationPresent(UnionConfig.Range.class) || field.get(object) instanceof Number) {
                    UnionConfig.Range range = null;
                    if (field.isAnnotationPresent(UnionConfig.Range.class)) {
                        range = field.getAnnotation(UnionConfig.Range.class);
                        Double d3 = range.min();
                        max = range.max();
                        useSlider = range.useSlider();
                    }
                    if (field.get(object) instanceof Integer) {
                        name = ConfigBuilder.configName(configEntry, "Integer");
                        Integer n = range != null ? ((Double)var25_34).intValue() : Integer.MIN_VALUE;
                        max = range != null ? ((Double)max).intValue() : Integer.MAX_VALUE;
                        writer.putRanged(name, (Integer)field.get(object), n, (Integer)max, Integer.class, (String)comment);
                    } else if (field.get(object) instanceof Float) {
                        name = ConfigBuilder.configName(configEntry, "Float");
                        Float f = Float.valueOf(range != null ? ((Double)var25_34).floatValue() : Float.MIN_VALUE);
                        max = Float.valueOf(range != null ? ((Double)max).floatValue() : Float.MAX_VALUE);
                        writer.putRanged(name, (Float)field.get(object), f, (Float)max, Float.class, (String)comment);
                    } else if (field.get(object) instanceof Long) {
                        name = ConfigBuilder.configName(configEntry, "Long");
                        writer.putRanged(name, (Long)field.get(object), range != null ? ((Double)var25_34).longValue() : Long.MIN_VALUE, range != null ? ((Double)max).longValue() : Long.MAX_VALUE, Long.class, (String)comment);
                    } else if (field.get(object) instanceof Short) {
                        name = ConfigBuilder.configName(configEntry, "Short");
                        writer.putRanged(name, (Short)field.get(object), range != null ? ((Double)var25_34).shortValue() : (short)Short.MIN_VALUE, range != null ? ((Double)max).shortValue() : (short)Short.MAX_VALUE, Short.class, (String)comment);
                    } else if (field.get(object) instanceof Byte) {
                        name = ConfigBuilder.configName(configEntry, "Byte");
                        writer.putRanged(name, (Byte)field.get(object), range != null ? ((Double)var25_34).byteValue() : (byte)-128, range != null ? ((Double)max).byteValue() : (byte)127, Byte.class, (String)comment);
                    } else {
                        name = ConfigBuilder.configName(configEntry, "Double");
                        writer.putRanged(name, (Double)field.get(object), range != null ? (Double)var25_34 : Double.MIN_VALUE, range != null ? (Double)max : Double.MAX_VALUE, Double.class, (String)comment);
                    }
                } else {
                    name = ConfigBuilder.configName(configEntry);
                    writer.put(name, field.get(object));
                }
                ConfigHolder<Double> holder = new ConfigHolder<Double>(name, writer, (Double)field.get(object), filename, (List<Component>)saved_comment, useSlider, (Double)var25_26, (Double)max, configEntry.translatable(), translatableComments);
                holders.add(holder);
                ConfigBuilder.putValue(side, config.name() + "=" + ConfigBuilder.configName(configEntry), holder);
                d.execute();
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    static <T> void rectify(boolean foundElement, ConfigHolder<?> holder, T def, Supplier<T> val, String message, Runnable onRectify) {
        ConfigHolder<?> holderCast = holder;
        if (!foundElement) {
            System.err.println(holderCast.nameInQuotes() + message + String.valueOf(def));
            holderCast.update(def);
            onRectify.run();
        } else {
            System.out.println("Actually " + holder.name);
            holderCast.update(val.get());
        }
    }

    public static ConfigHolder<?> updateSharedValues(ConfigHolder<?> h, String value) {
        if (h != null) {
            TomlParseResult t = Toml.parse((String)value);
            Object t2 = h.defaultValue;
            if (t2 instanceof Boolean) {
                Boolean bo = (Boolean)t2;
                e = t.getBoolean(h.nameInQuotes());
                ConfigBuilder.rectify(e != null, h, bo, () -> e, " is broken, defaulting to ", () -> {});
            } else {
                e = h.defaultValue;
                if (e instanceof Enum) {
                    Enum en = (Enum)e;
                    acceptableValues = Arrays.asList(en.getDeclaringClass().getEnumConstants());
                    String e = t.getString(h.nameInQuotes());
                    ConfigBuilder.rectify(e != null, h, en, () -> Enum.valueOf(en.getDeclaringClass(), e), " is broken, defaulting to ", () -> {});
                } else {
                    acceptableValues = h.defaultValue;
                    if (acceptableValues instanceof String) {
                        String st = (String)acceptableValues;
                        e = t.getString(h.nameInQuotes());
                        ConfigBuilder.rectify(e != null, h, st, () -> e, " is broken, defaulting to ", () -> {});
                    } else {
                        e = h.defaultValue;
                        if (e instanceof Integer) {
                            Integer in = (Integer)e;
                            e = t.getLong(h.nameInQuotes());
                            ConfigBuilder.rectify(e != null, h, in, () -> e.intValue(), " is broken, defaulting to ", () -> {});
                        } else {
                            e = h.defaultValue;
                            if (e instanceof Float) {
                                Float fl = (Float)e;
                                e = t.getDouble(h.nameInQuotes());
                                ConfigBuilder.rectify(e != null, h, fl, () -> Float.valueOf(e.floatValue()), " is broken, defaulting to ", () -> {});
                            } else {
                                e = h.defaultValue;
                                if (e instanceof Long) {
                                    Long lo = (Long)e;
                                    e = t.getLong(h.nameInQuotes());
                                    ConfigBuilder.rectify(e != null, h, lo, () -> e, " is broken, defaulting to ", () -> {});
                                } else {
                                    e = h.defaultValue;
                                    if (e instanceof Short) {
                                        Short sh = (Short)e;
                                        e = t.getLong(h.nameInQuotes());
                                        ConfigBuilder.rectify(e != null, h, sh, () -> e.shortValue(), " is broken, defaulting to ", () -> {});
                                    } else {
                                        e = h.defaultValue;
                                        if (e instanceof Double) {
                                            Double d = (Double)e;
                                            e = t.getDouble(h.nameInQuotes());
                                            ConfigBuilder.rectify(e != null, h, d, () -> e, " is broken, defaulting to ", () -> {});
                                        } else {
                                            e = h.defaultValue;
                                            if (e instanceof Collection) {
                                                Collection co = (Collection)e;
                                                e = t.getArray(h.nameInQuotes());
                                                ConfigBuilder.rectify(e != null, h, co, () -> e.toList(), " is broken, defaulting to ", () -> {});
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return h;
    }

    static Map<String, ConfigHolder<?>> retrieveValues(ConfigSide ... sides) {
        HashMap values = new HashMap();
        boolean hasClient = false;
        boolean hasCommon = false;
        boolean hasServer = false;
        for (ConfigSide side : sides) {
            if (side == ConfigSide.Client && !hasClient) {
                hasClient = true;
                values.putAll(client_values);
            }
            if (side == ConfigSide.Shared && !hasCommon) {
                hasCommon = true;
                values.putAll(common_values);
            }
            if (side != ConfigSide.Server || hasServer) continue;
            hasServer = true;
            values.putAll(server_values);
        }
        return values;
    }

    static void putValue(ConfigSide side, String key, ConfigHolder<?> value) {
        if (side == ConfigSide.Client) {
            client_values.put(key, value);
        }
        if (side == ConfigSide.Shared) {
            common_values.put(key, value);
        }
        if (side == ConfigSide.Server) {
            server_values.put(key, value);
        }
    }

    public static String configName(UnionConfig.Entry configEntry, String dataType) {
        if (configEntry.group().isEmpty()) {
            if (!dataType.isEmpty()) {
                return dataType + ": " + configEntry.name();
            }
            return configEntry.name();
        }
        if (!dataType.isEmpty()) {
            return configEntry.group() + "." + dataType + ": " + configEntry.name();
        }
        return configEntry.group() + "." + configEntry.name();
    }

    public static String configName(UnionConfig.Entry configEntry) {
        return ConfigBuilder.configName(configEntry, "");
    }

    static ConfigHolder<?> getConfigValue(UnionConfig config, UnionConfig.Entry configEntry, List<TomlWriter> corrections) {
        if (config != null && configEntry != null) {
            ConfigHolder<Integer> h = ConfigBuilder.retrieveValues(ConfigSide.Client, ConfigSide.Shared, ConfigSide.Server).getOrDefault(config.name() + "=" + ConfigBuilder.configName(configEntry), new ConfigHolder<Integer>("empty", null, (Integer)((Object)"no_file"), "nothing_was_found", null, false, 0, 0, "", new String[0]));
            try {
                TomlParseResult t = Toml.parse((Path)new File(LoaderHelper.configPath().toString() + File.separator + h.parentFile).toPath());
                Object t2 = h.defaultValue;
                if (t2 instanceof Boolean) {
                    Boolean bo = (Boolean)t2;
                    e = t.getBoolean(h.nameInQuotes());
                    ConfigBuilder.rectify(e != null, h, bo, () -> e, " is broken, correcting to ", () -> {
                        if (!corrections.contains(h.value)) {
                            corrections.add(h.value);
                        }
                    });
                } else {
                    e = h.defaultValue;
                    if (e instanceof Enum) {
                        Enum en = (Enum)e;
                        acceptableValues = Arrays.asList(en.getDeclaringClass().getEnumConstants());
                        String e = t.getString(h.nameInQuotes());
                        ConfigBuilder.rectify(e != null, h, en, () -> Enum.valueOf(en.getDeclaringClass(), e), " is broken, correcting to ", () -> {
                            if (!corrections.contains(h.value)) {
                                corrections.add(h.value);
                            }
                        });
                    } else {
                        acceptableValues = h.defaultValue;
                        if (acceptableValues instanceof String) {
                            String st = (String)acceptableValues;
                            e = t.getString(h.nameInQuotes());
                            ConfigBuilder.rectify(e != null, h, st, () -> e, " is broken, correcting to ", () -> {
                                if (!corrections.contains(h.value)) {
                                    corrections.add(h.value);
                                }
                            });
                        } else {
                            e = h.defaultValue;
                            if (e instanceof Integer) {
                                Integer in = (Integer)e;
                                e = t.getLong(h.nameInQuotes());
                                ConfigBuilder.rectify(e != null, h, in, () -> e.intValue(), " is broken, correcting to ", () -> {
                                    if (!corrections.contains(h.value)) {
                                        corrections.add(h.value);
                                    }
                                });
                            } else {
                                e = h.defaultValue;
                                if (e instanceof Float) {
                                    Float fl = (Float)e;
                                    e = t.getDouble(h.nameInQuotes());
                                    ConfigBuilder.rectify(e != null, h, fl, () -> Float.valueOf(e.floatValue()), " is broken, correcting to ", () -> {
                                        if (!corrections.contains(h.value)) {
                                            corrections.add(h.value);
                                        }
                                    });
                                } else {
                                    e = h.defaultValue;
                                    if (e instanceof Long) {
                                        Long lo = (Long)e;
                                        e = t.getLong(h.nameInQuotes());
                                        ConfigBuilder.rectify(e != null, h, lo, () -> e, " is broken, correcting to ", () -> {
                                            if (!corrections.contains(h.value)) {
                                                corrections.add(h.value);
                                            }
                                        });
                                    } else {
                                        e = h.defaultValue;
                                        if (e instanceof Short) {
                                            Short sh = (Short)e;
                                            e = t.getLong(h.nameInQuotes());
                                            ConfigBuilder.rectify(e != null, h, sh, () -> e.shortValue(), " is broken, correcting to ", () -> {
                                                if (!corrections.contains(h.value)) {
                                                    corrections.add(h.value);
                                                }
                                            });
                                        } else {
                                            e = h.defaultValue;
                                            if (e instanceof Double) {
                                                Double d = (Double)e;
                                                e = t.getDouble(h.nameInQuotes());
                                                ConfigBuilder.rectify(e != null, h, d, () -> e, " is broken, correcting to ", () -> {
                                                    if (!corrections.contains(h.value)) {
                                                        corrections.add(h.value);
                                                    }
                                                });
                                            } else {
                                                e = h.defaultValue;
                                                if (e instanceof Collection) {
                                                    Collection co = (Collection)e;
                                                    e = t.getArray(h.nameInQuotes());
                                                    ConfigBuilder.rectify(e != null, h, co, () -> e.toList(), " is broken, correcting to ", () -> {
                                                        if (!corrections.contains(h.value)) {
                                                            corrections.add(h.value);
                                                        }
                                                    });
                                                } else {
                                                    System.out.println("Can read " + h.parentFile + " The Value of " + ConfigBuilder.configName(configEntry) + " is " + String.valueOf(t.get(h.nameInQuotes())));
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (h.recievedChanges) {
                    h.recievedChanges = false;
                    if (configEntry.side() == ConfigSide.Shared) {
                        shared_changes.put(config.name() + "=" + ConfigBuilder.configName(configEntry), new TomlWriter(null).put(h.name, h.get()).build());
                    }
                }
                shared_starter.put(config.name() + "=" + ConfigBuilder.configName(configEntry), new TomlWriter(null).put(h.name, h.get()).build());
            }
            catch (IOException | IllegalStateException e) {
                System.err.println(e);
            }
            return h;
        }
        return null;
    }

    public static void sendConfigValues(ServerPlayer player) {
        ConfigClassBuilder.reloadAll(null);
        ConfigObjectBuilder.reloadAll(null);
        if (shared_starter.size() > 0) {
            new ClientboundConfigPacket(shared_starter).send(player);
            shared_starter.clear();
        }
    }

    public static Map<String, ConfigHolder<?>> getValues(UnionConfig config) {
        HashMap values2 = new HashMap();
        for (String configValue : ConfigBuilder.retrieveValues(ConfigSide.Client, ConfigSide.Shared, ConfigSide.Server).keySet()) {
            if (!configValue.split("=")[0].equals(config.name())) continue;
            values2.put(configValue, ConfigBuilder.retrieveValues(ConfigSide.Client, ConfigSide.Shared, ConfigSide.Server).get(configValue));
        }
        return values2;
    }

    private static void handleConfigEvent(String modid) {
        if (!modidList.contains(modid)) {
            modidList.add(modid);
        }
    }

    public static void registerConfig(Class<?> configClass) {
        ConfigBuilder.registerConfig(null, configClass);
    }

    public static void registerConfig(MinecraftMod mod, Class<?> configClass) {
        if (configClass.isAnnotationPresent(UnionConfig.class) && !ConfigClassBuilder.configs.containsKey(configClass)) {
            UnionConfig con = configClass.getAnnotation(UnionConfig.class);
            UnionLib.debug("Registered the config for " + con.name());
            if (mod != null) {
                ConfigBuilder.handleConfigEvent(mod.getModid());
            }
            ConfigClassBuilder.configs.put(configClass, Lists.newArrayList());
            ConfigClassBuilder.registerConfigurations(mod, configClass);
            ConfigClassBuilder.loadConfigs(configClass);
        } else {
            if (!configClass.isAnnotationPresent(UnionConfig.class)) {
                throw new RuntimeException("You cannot register a config if it does not have the UnionConfig annotation");
            }
            if (ConfigClassBuilder.configs.containsKey(configClass)) {
                throw new RuntimeException("This config class has already been regtistered");
            }
        }
    }

    public static void registerConfig(ConfigObject configObject) {
        ConfigBuilder.registerConfig(null, configObject);
    }

    public static void registerConfig(MinecraftMod mod, ConfigObject configObject) {
        if (configObject.getClass().isAnnotationPresent(UnionConfig.class) && !ConfigObjectBuilder.configs.containsKey(configObject)) {
            UnionConfig con = configObject.getClass().getAnnotation(UnionConfig.class);
            UnionLib.debug("Registered the config for " + con.name());
            if (mod != null) {
                ConfigBuilder.handleConfigEvent(mod.getModid());
            }
            ConfigObjectBuilder.configs.put(configObject, Lists.newArrayList());
            ConfigObjectBuilder.registerConfigurations(mod, configObject);
            ConfigObjectBuilder.loadConfigs(configObject);
        } else {
            if (!configObject.getClass().isAnnotationPresent(UnionConfig.class)) {
                throw new RuntimeException("You cannot register a config if it does not have the UnionConfig annotation");
            }
            if (ConfigObjectBuilder.configs.containsKey(configObject)) {
                throw new RuntimeException("This config object has already been regtistered");
            }
        }
    }

    public static void loadConfig(String path, String fileName) {
        File configFile = new File(path, fileName);
        configFile.getParentFile().mkdirs();
        UnionLib.debug(path);
        Path directoryPath = configFile.getParentFile().toPath();
        if (!watcher.containsKey(directoryPath.toString())) {
            TomlWatcher watch = new TomlWatcher(directoryPath, filex -> {
                if (LoaderHelper.isClientInstance()) {
                    ConfigBuilder.reload(filex, ConfigSide.Client);
                    Syncer.syncFromIntegratedServer(filex);
                }
                if (LoaderHelper.isServerInstance()) {
                    ConfigBuilder.reload(filex, ConfigSide.Shared, ConfigSide.Server);
                    if (shared_changes.size() > 0) {
                        new ClientboundConfigPacket(shared_changes).send((MinecraftServer)currentDedicatedServerInstance);
                        shared_changes.clear();
                    }
                }
            });
            watch.setName("UnionLib Toml Reader " + watcher.size());
            try {
                watch.start();
                watcher.put(directoryPath.toString(), watch);
            }
            catch (IllegalThreadStateException e) {
                System.err.println("Failed to start watcher thread " + String.valueOf(e));
            }
        }
        watcher.get(directoryPath.toString()).watchFile(fileName);
    }

    public static void reload(String name, ConfigSide ... exceptions) {
        UnionConfig con;
        for (Class<?> configClass : ConfigClassBuilder.configs.keySet()) {
            con = configClass.getAnnotation(UnionConfig.class);
            if (!con.autoReload() || !name.isEmpty() && !ConfigClassBuilder.configs.get(configClass).contains(name)) continue;
            ConfigBuilder.read(configClass, null, null, new ConfigSide[0]);
            UnionLib.debug("Found change in " + con.name() + "'s config file. Reloading values");
        }
        for (ConfigObject configObject : ConfigObjectBuilder.configs.keySet()) {
            con = configObject.getClass().getAnnotation(UnionConfig.class);
            if (!con.autoReload() || !name.isEmpty() && !ConfigObjectBuilder.configs.get(configObject).contains(name)) continue;
            ConfigBuilder.read(configObject.getClass(), configObject, null, new ConfigSide[0]);
            UnionLib.debug("Found change in " + con.name() + "'s config file. Reloading values");
        }
    }

    public static void reload(ConfigSide ... exceptions) {
        ConfigBuilder.reload("", exceptions);
    }

    public static void load(ConfigSide ... exceptions) {
        UnionConfig con;
        UnionLib.debug("Loading all values from the config files into their respective configuration variables");
        for (Class<?> configClass : ConfigClassBuilder.configs.keySet()) {
            con = configClass.getAnnotation(UnionConfig.class);
            ConfigBuilder.read(configClass, null, null, exceptions);
            UnionLib.debug("Loading " + con.name() + "'s config");
        }
        for (ConfigObject configObject : ConfigObjectBuilder.configs.keySet()) {
            con = configObject.getClass().getAnnotation(UnionConfig.class);
            ConfigBuilder.read(configObject.getClass(), configObject, null, exceptions);
            UnionLib.debug("Loading " + con.name() + "'s config");
        }
    }

    static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }

    protected static class Init {
        protected List<ConfigHolder<?>> holders = Lists.newArrayList();
        protected TomlWriter writer;
        protected String filename;

        protected Init(String name, UnionConfig con, String appendage) {
            this.filename = name + (String)(con.appendWithType() ? "-" + appendage : "") + ".toml";
            this.writer = new TomlWriter(new File(LoaderHelper.configPath().toString() + File.separator + this.filename));
        }
    }

    static class Syncer {
        Syncer() {
        }

        static void syncFromIntegratedServer(String file) {
            if (Minecraft.getInstance().getSingleplayerServer() != null) {
                ConfigBuilder.reload(file, ConfigSide.Shared, ConfigSide.Server);
                if (shared_changes.size() > 0) {
                    new ClientboundConfigPacket(shared_changes).send((MinecraftServer)Minecraft.getInstance().getSingleplayerServer());
                    shared_changes.clear();
                }
            }
        }
    }
}

