/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.mixin;

import com.stereowalker.unionlib.hook.EntityHook;
import com.stereowalker.unionlib.world.level.material.FluidProperties;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin
implements EntityHook {
    FluidState fluidInEyes;
    Object2DoubleMap<FluidProperties> fluidHeights = new Object2DoubleArrayMap(2);

    @Shadow
    public final double getZ() {
        return 0.0;
    }

    @Shadow
    public final double getX() {
        return 0.0;
    }

    @Shadow
    public double getEyeY() {
        return 0.0;
    }

    @Shadow
    public Level level() {
        return null;
    }

    @Inject(method={"updateFluidOnEyes"}, at={@At(value="HEAD")})
    public void updateFluidOnEyes_inject_head(CallbackInfo ci) {
        this.fluidInEyes = Fluids.EMPTY.defaultFluidState();
    }

    @Inject(method={"updateFluidOnEyes"}, at={@At(value="TAIL")})
    public void updateFluidOnEyes_inject_tail(CallbackInfo ci) {
        double d = this.getEyeY();
        BlockPos blockpos = BlockPos.containing((double)this.getX(), (double)d, (double)this.getZ());
        FluidState fluidstate = this.level().getFluidState(blockpos);
        if ((double)((float)blockpos.getY() + fluidstate.getHeight((BlockGetter)this.level(), blockpos)) > d) {
            this.fluidInEyes = fluidstate;
        }
    }

    @Override
    public FluidState fluidInEyes() {
        return this.fluidInEyes;
    }

    @Override
    public Object2DoubleMap<FluidProperties> fluidHeights() {
        return this.fluidHeights;
    }

    @Inject(method={"updateInWaterStateAndDoFluidPushing"}, at={@At(value="HEAD")})
    public void updateInWaterStateAndDoFluidPushing_inject_head(CallbackInfoReturnable<Boolean> cir) {
        this.fluidHeights.clear();
    }
}

