/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.mixin.inserts;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.stereowalker.unionlib.insert.Inserts;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerInsertMixin
extends Player {
    private Either<Player.BedSleepingProblem, Unit> sleep = null;

    @Shadow
    public boolean bedInRange(BlockPos pos, Direction d) {
        return false;
    }

    @Shadow
    public boolean bedBlocked(BlockPos pos, Direction d) {
        return false;
    }

    @Shadow
    public ServerLevel serverLevel() {
        return null;
    }

    @Shadow
    public void setRespawnPosition(ResourceKey<Level> dimension, BlockPos pAt, float yRot, boolean b, boolean c) {
    }

    public ServerPlayerInsertMixin(Level p_36114_, BlockPos p_36115_, float p_36116_, GameProfile p_36117_) {
        super(p_36114_, p_36115_, p_36116_, p_36117_);
    }

    @Redirect(method={"startSleepInBed"}, at=@At(value="INVOKE", target="Lcom/mojang/datafixers/util/Either;left(Ljava/lang/Object;)Lcom/mojang/datafixers/util/Either;"))
    private Either<Player.BedSleepingProblem, Unit> startSleepInBed_r1(Object c, BlockPos bedPos) {
        ServerPlayer player = (ServerPlayer)this;
        Player.BedSleepingProblem p = (Player.BedSleepingProblem)c;
        if (this.sleep != null && this.sleep.right().isPresent()) {
            Either either = super.startSleepInBed(bedPos).ifRight(unit -> {
                this.awardStat(Stats.SLEEP_IN_BED);
                CriteriaTriggers.SLEPT_IN_BED.trigger(player);
            });
            if (!this.serverLevel().canSleepThroughNights()) {
                this.displayClientMessage((Component)Component.translatable((String)"sleep.not_possible"), true);
            }
            ((ServerLevel)this.level()).updateSleepingPlayerList();
            return either;
        }
        return this.sleep == null ? Either.left((Object)p) : this.sleep;
    }

    @Redirect(method={"startSleepInBed"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;startSleepInBed(Lnet/minecraft/core/BlockPos;)Lcom/mojang/datafixers/util/Either;"))
    private Either<Player.BedSleepingProblem, Unit> startSleepInBed_r2(Player player, BlockPos bedPos) {
        if (this.sleep != null && this.sleep.left().isPresent()) {
            return this.sleep;
        }
        return super.startSleepInBed(bedPos);
    }

    @Inject(method={"startSleepInBed"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getValue(Lnet/minecraft/world/level/block/state/properties/Property;)Ljava/lang/Comparable;")})
    public void startSleepInBed_i1(BlockPos bedPos, CallbackInfoReturnable<Either<Player.BedSleepingProblem, Unit>> cir) {
        ServerPlayer player = (ServerPlayer)this;
        this.sleep = null;
        Supplier<Either> vanilla = () -> {
            Direction direction = (Direction)this.level().getBlockState(bedPos).getValue((Property)HorizontalDirectionalBlock.FACING);
            if (this.isSleeping() || !this.isAlive()) {
                return Either.left((Object)Player.BedSleepingProblem.OTHER_PROBLEM);
            }
            if (!this.level().dimensionType().natural()) {
                return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_HERE);
            }
            if (!this.bedInRange(bedPos, direction)) {
                return Either.left((Object)Player.BedSleepingProblem.TOO_FAR_AWAY);
            }
            if (this.bedBlocked(bedPos, direction)) {
                return Either.left((Object)Player.BedSleepingProblem.OBSTRUCTED);
            }
            if (this.level().isDay()) {
                return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
            }
            if (!this.isCreative()) {
                double d = 8.0;
                double e = 5.0;
                Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)bedPos);
                List list = this.level().getEntitiesOfClass(Monster.class, new AABB(vec3.x() - 8.0, vec3.y() - 5.0, vec3.z() - 8.0, vec3.x() + 8.0, vec3.y() + 5.0, vec3.z() + 8.0), monster -> monster.isPreventingPlayerRest((Player)this));
                if (!list.isEmpty()) {
                    return Either.left((Object)Player.BedSleepingProblem.NOT_SAFE);
                }
            }
            return Either.right((Object)Unit.INSTANCE);
        };
        Either van = vanilla.get();
        MutableObject evt = new MutableObject((Object)van);
        Inserts.PLAYER_CAN_SLEEP.insert((Player)player, bedPos, van.left().orElse(null), ((Either)evt.getValue()).left().orElse(null), x -> {
            this.sleep = x == null ? Either.right((Object)Unit.INSTANCE) : Either.left((Object)x);
        });
    }
}

