/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.mod;

import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.api.collectors.BrewingRecipeCollector;
import com.stereowalker.unionlib.api.collectors.CommandCollector;
import com.stereowalker.unionlib.api.collectors.ConfigCollector;
import com.stereowalker.unionlib.api.collectors.DefaultAttributeModifier;
import com.stereowalker.unionlib.api.collectors.FluidPropertyCollector;
import com.stereowalker.unionlib.api.collectors.InsertCollector;
import com.stereowalker.unionlib.api.collectors.ReloadListeners;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabBuilder;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabPopulator;
import com.stereowalker.unionlib.api.registries.RegistryCollector;
import com.stereowalker.unionlib.forge.ForgeMod;
import com.stereowalker.unionlib.forge.PlatformHelper;
import com.stereowalker.unionlib.mod.ClientSegment;
import com.stereowalker.unionlib.mod.ModHandler;
import com.stereowalker.unionlib.mod.ServerSegment;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinecraftMod
extends ForgeMod {
    private String modid;
    private LoadType loadType;
    private ClientSegment clientSegment;
    private ServerSegment serverSegment;

    public LoadType getEnv(Supplier<ClientSegment> clientSegment, Supplier<ServerSegment> serverSegment) {
        if (clientSegment == null && serverSegment != null) {
            this.serverSegment = serverSegment.get();
            this.serverSegment.setOwner(this);
            return LoadType.SERVER;
        }
        if (clientSegment != null && serverSegment == null) {
            if (PlatformHelper.isClientInstance()) {
                this.clientSegment = clientSegment.get();
                this.clientSegment.setOwner(this);
            }
            return LoadType.CLIENT;
        }
        if (clientSegment != null && serverSegment != null) {
            this.serverSegment = serverSegment.get();
            this.serverSegment.setOwner(this);
            if (PlatformHelper.isClientInstance()) {
                this.clientSegment = clientSegment.get();
                this.clientSegment.setOwner(this);
            }
            return LoadType.BOTH;
        }
        System.err.println(this.modid + " does not have any segments attached. This will cause errors");
        return null;
    }

    public MinecraftMod(String modid, Supplier<ClientSegment> clientSegment, Supplier<ServerSegment> serverSegment, boolean shouldLoadMod) {
        this.modid = modid;
        this.loadType = this.getEnv(clientSegment, serverSegment);
        if (shouldLoadMod && !ModHandler.isModRegistered(modid)) {
            this.onModConstruct();
            ModHandler.registerMod(this);
            UnionLib.debug("Starting up: " + this.modid, true);
            if (PlatformHelper.isClientInstance()) {
                this.setupConfigScreen(this.clientSegment);
            }
        }
    }

    public void onModConstruct() {
    }

    public void onModStartup() {
    }

    public void onModStartupInClient() {
    }

    public void modifyDefaultEntityAttributes(DefaultAttributeModifier modifier) {
    }

    public void populateCreativeTabs(CreativeTabPopulator populator) {
    }

    public void registerCreativeTabs(CreativeTabBuilder builder) {
    }

    public void registerClientRelaodableResources(ReloadListeners reloadListener) {
    }

    public void registerServerRelaodableResources(ReloadListeners reloadListener) {
    }

    public void registerInserts(InsertCollector collector) {
    }

    public void setupConfigs(ConfigCollector collector) {
    }

    public void setupCommands(CommandCollector collector) {
    }

    public void setupRegistries(RegistryCollector collector) {
    }

    public void setupBrewingRecipes(BrewingRecipeCollector collector) {
    }

    public void setupFluids(FluidPropertyCollector collector) {
    }

    public MinecraftMod(String modid, Supplier<ClientSegment> clientSegment, Supplier<ServerSegment> serverSegment) {
        this(modid, clientSegment, serverSegment, true);
    }

    public LoadType getLoadType() {
        return this.loadType;
    }

    @Override
    public String getModid() {
        return this.modid;
    }

    public Logger getLogger() {
        return LogManager.getLogger((String)this.modid);
    }

    public ResourceLocation location(String name) {
        return VersionHelper.toLoc(this.modid, name);
    }

    public String locationString(String name) {
        return this.modid + ":" + name;
    }

    public ClientSegment getClientSegment() {
        return this.clientSegment;
    }

    public ServerSegment getServerSegment() {
        return this.serverSegment;
    }

    public static enum LoadType {
        CLIENT,
        BOTH,
        SERVER;


        public boolean onClient() {
            return this == CLIENT || this == BOTH;
        }

        public boolean onServer() {
            return this == SERVER || this == BOTH;
        }
    }
}

