/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.supporter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stereowalker.unionlib.client.model.HatModel;
import com.stereowalker.unionlib.supporter.Cosmetic;
import com.stereowalker.unionlib.supporter.Cosmetics;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public class CosmeticHandler {
    public static <T extends LivingEntity, M extends EntityModel<T>> void setupPose(LivingEntityRenderer<T, M> ler, T entity, float arg1, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        float k;
        Direction direction;
        Entity entity2;
        float f = Mth.rotLerp((float)partialTicks, (float)entity.yBodyRotO, (float)entity.yBodyRot);
        float g = Mth.rotLerp((float)partialTicks, (float)entity.yHeadRotO, (float)entity.yHeadRot);
        float h = g - f;
        if (entity.isPassenger() && (entity2 = entity.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity2;
            f = Mth.rotLerp((float)partialTicks, (float)livingEntity.yBodyRotO, (float)livingEntity.yBodyRot);
            h = g - f;
            float i = Mth.wrapDegrees((float)h);
            if (i < -85.0f) {
                i = -85.0f;
            }
            if (i >= 85.0f) {
                i = 85.0f;
            }
            f = g - i;
            if (i * i > 2500.0f) {
                f += i * 0.2f;
            }
            h = g - f;
        }
        float j = Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
        if (LivingEntityRenderer.isEntityUpsideDown(entity)) {
            j *= -1.0f;
            h *= -1.0f;
        }
        h = Mth.wrapDegrees((float)h);
        if (entity.hasPose(Pose.SLEEPING) && (direction = entity.getBedOrientation()) != null) {
            k = entity.getEyeHeight(Pose.STANDING) - 0.1f;
            poseStack.translate((float)(-direction.getStepX()) * k, 0.0f, (float)(-direction.getStepZ()) * k);
        }
        float ix = entity.getScale();
        poseStack.scale(ix, ix, ix);
        k = ((LERAccess)ler).getBobA(entity, partialTicks);
        ((LERAccess)ler).setupRotationsA(entity, poseStack, k, f, partialTicks, ix);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        ((LERAccess)ler).scaleA(entity, poseStack, partialTicks);
        poseStack.translate(0.0f, -1.501f, 0.0f);
    }

    public static <T extends LivingEntity, M extends EntityModel<T>> void addCosmetic(LivingEntityRenderer<T, M> lienr, T entity, PoseStack poseStack, MultiBufferSource buffer, HatModel<?> hatmodel, int packedLight, float partialTicks, HumanoidModel playerModel) {
        hatmodel.attach(playerModel);
        Minecraft minecraft = Minecraft.getInstance();
        boolean flag = ((LERAccess)lienr).isBodyVisibleA(entity);
        boolean flag1 = !flag && !entity.isInvisibleTo((Player)minecraft.player);
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)hatmodel.getHat().texture()));
        int i = LivingEntityRenderer.getOverlayCoords(entity, (float)((LERAccess)lienr).getWhiteOverlayProgressA(entity, partialTicks));
        hatmodel.renderToBuffer(poseStack, vertexConsumer, packedLight, i, flag1 ? 0x26FFFFFF : -1);
    }

    public static boolean doesPlayerNeedCosmetic(Player player) {
        return Cosmetics.equippedCosmetics().containsKey(player.getUUID());
    }

    public static boolean willPlayerShowCosmetic(UUID player) {
        return !Cosmetics.equippedCosmetics().getOrDefault(player, "").isEmpty();
    }

    public static boolean willPlayerShowCosmetic(Player player) {
        return CosmeticHandler.willPlayerShowCosmetic(player.getUUID());
    }

    public static Cosmetic getHat(Player player) {
        return CosmeticHandler.getHat(player.getUUID());
    }

    public static Cosmetic getHat(UUID player) {
        if (CosmeticHandler.willPlayerShowCosmetic(player)) {
            return Cosmetics.allCosmetics().getOrDefault(Cosmetics.equippedCosmetics().get(player), Cosmetics.NONE);
        }
        return Cosmetics.NONE;
    }

    public static interface LERAccess<T extends LivingEntity, M extends EntityModel<T>> {
        public boolean isBodyVisibleA(T var1);

        public float getBobA(T var1, float var2);

        public float getWhiteOverlayProgressA(T var1, float var2);

        public void scaleA(T var1, PoseStack var2, float var3);

        public void setupRotationsA(T var1, PoseStack var2, float var3, float var4, float var5, float var6);
    }
}

