/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.util;

import com.stereowalker.unionlib.util.VersionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class EntityHelper {
    public static int getXpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    public static int getActualExperienceTotal(Player player) {
        int xpTot = 0;
        for (int i = 0; i < player.experienceLevel; ++i) {
            xpTot += EntityHelper.getXpBarCap(i);
        }
        int f = Mth.floor((float)(player.experienceProgress * (float)player.getXpNeededForNextLevel()));
        return xpTot += f;
    }

    public static float getJumpUpwardsMotion(LivingEntity living) {
        return 0.42f * EntityHelper.getJumpFactor((Entity)living);
    }

    protected static float getJumpFactor(Entity entity) {
        float f = entity.level().getBlockState(entity.blockPosition()).getBlock().getJumpFactor();
        float f1 = entity.level().getBlockState(EntityHelper.getPositionUnderneath(entity)).getBlock().getJumpFactor();
        return (double)f == 1.0 ? f1 : f;
    }

    protected static BlockPos getPositionUnderneath(Entity entity) {
        return VersionHelper.posFromDouble(entity.getX(), entity.getBoundingBox().minY - 0.5000001, entity.getZ());
    }

    public static boolean mayFly(Player player) {
        return player.getAbilities().mayfly;
    }
}

