/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.screens.config;

import com.google.common.collect.ImmutableList;
import com.stereowalker.unionlib.client.gui.screens.config.ConfigScreen;
import com.stereowalker.unionlib.client.gui.screens.config.MinecraftModConfigsScreen;
import com.stereowalker.unionlib.config.ConfigClassBuilder;
import com.stereowalker.unionlib.config.ConfigObject;
import com.stereowalker.unionlib.config.ConfigObjectBuilder;
import com.stereowalker.unionlib.util.ScreenHelper;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class MultiConfigList
extends ContainerObjectSelectionList<Entry> {
    public MultiConfigList(Minecraft mcIn, MinecraftModConfigsScreen screen) {
        super(mcIn, screen.width, screen.layout.getContentHeight(), screen.layout.getHeaderHeight(), 25);
        if (screen.configObjects != null) {
            for (ConfigObject configObject : screen.configObjects) {
                this.addEntry((AbstractSelectionList.Entry)new ModConfigObjectEntry(configObject, screen));
            }
        }
        if (screen.configClasses != null) {
            for (Class<?> clazz : screen.configClasses) {
                this.addEntry((AbstractSelectionList.Entry)new ModConfigClassEntry(clazz, screen));
            }
        }
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 20;
    }

    public int getRowWidth() {
        return 200;
    }

    public class ModConfigObjectEntry
    extends Entry {
        private ModConfigObjectEntry(ConfigObject obj, Screen screen) {
            super(MultiConfigList.this);
            this.configButton = ScreenHelper.buttonBuilder((Component)ConfigObjectBuilder.getConfigName(obj), onPress -> MultiConfigList.this.minecraft.setScreen((Screen)new ConfigScreen(screen, obj))).bounds(0, 0, 200, 20).build();
        }
    }

    public class ModConfigClassEntry
    extends Entry {
        private ModConfigClassEntry(Class<?> cla, Screen screen) {
            super(MultiConfigList.this);
            this.configButton = ScreenHelper.buttonBuilder((Component)ConfigClassBuilder.getConfigName(cla), onPress -> MultiConfigList.this.minecraft.setScreen((Screen)new ConfigScreen(screen, cla))).bounds(0, 0, 200, 20).build();
        }
    }

    public abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        protected Button configButton;

        public Entry(MultiConfigList this$0) {
        }

        public void render(GuiGraphics guiGraphics, int index, int top, int left, int pWidth, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            ScreenHelper.setWidgetPosition((AbstractWidget)this.configButton, left, top);
            this.configButton.render(guiGraphics, p_230432_7_, p_230432_8_, p_230432_10_);
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.configButton);
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.configButton);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return this.configButton.mouseClicked(mouseX, mouseY, button);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            return this.configButton.mouseReleased(mouseX, mouseY, button);
        }
    }
}

