/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.api.collectors.BrewingRecipeCollector;
import com.stereowalker.unionlib.api.collectors.ColorOverrideCollector;
import com.stereowalker.unionlib.api.collectors.CommandCollector;
import com.stereowalker.unionlib.api.collectors.ConfigCollector;
import com.stereowalker.unionlib.api.collectors.FluidPropertyCollector;
import com.stereowalker.unionlib.api.collectors.MenuCollector;
import com.stereowalker.unionlib.api.collectors.PackCollector;
import com.stereowalker.unionlib.api.collectors.PacketCollector;
import com.stereowalker.unionlib.api.collectors.ParticleCollector;
import com.stereowalker.unionlib.api.collectors.RenderLayerCollector;
import com.stereowalker.unionlib.config.ConfigBuilder;
import com.stereowalker.unionlib.config.ConfigObject;
import com.stereowalker.unionlib.core.registries.Housing;
import com.stereowalker.unionlib.forge.PlatformHelper;
import com.stereowalker.unionlib.mod.ClientSegment;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.ModHandler;
import com.stereowalker.unionlib.mod.PacketHolder;
import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionPacket;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.level.material.FluidProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.util.MavenVersionStringHelper;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.brewing.BrewingRecipeRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.SimpleChannel;
import net.minecraftforge.network.simple.SimpleFlow;
import net.minecraftforge.network.simple.SimpleProtocol;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public abstract class ForgeMod {
    public SimpleChannel channel = null;
    public static final Map<Fluid, RegistryObject<FluidType>> fluidTypes = new HashMap<Fluid, RegistryObject<FluidType>>();
    static final List<Runnable> after = new ArrayList<Runnable>();

    public abstract String getModid();

    public IEventBus eventBus() {
        return FMLJavaModLoadingContext.get().getModEventBus();
    }

    public void commonStuff() {
        final MinecraftMod mod = (MinecraftMod)this;
        final DeferredRegister FLUIDTYPE = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)mod.getModid());
        mod.setupFluids(new FluidPropertyCollector(){

            @Override
            public void forFluid(final FluidProperties property, Supplier<Fluid> ... fluid) {
                FluidType TYPE = new FluidType(this, FluidType.Properties.create().descriptionId("block.survive.purified_water").canConvertToSource(true).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH).canHydrate(true).density(10).viscosity(10)){

                    public boolean supportsBoating(Boat boat) {
                        return property.supportsBoats(boat);
                    }

                    public boolean supportsBoating(FluidState state, Boat boat) {
                        return property.supportsBoats(state, boat);
                    }

                    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
                        return property.move(state, entity, movementVector, gravity);
                    }

                    public boolean canPushEntity(Entity entity) {
                        return property.canPushEntity(entity);
                    }

                    public boolean canSwim(Entity entity) {
                        return property.canSwim(entity);
                    }

                    public boolean canExtinguish(Entity entity) {
                        return property.canExtinguish(entity);
                    }

                    public boolean canDrownIn(LivingEntity entity) {
                        return property.canDrownIn(entity);
                    }

                    public double motionScale(Entity entity) {
                        return property.motionScale(entity);
                    }

                    public float getFallDistanceModifier(Entity entity) {
                        return property.fallDistanceModifier(entity);
                    }

                    public void setItemMovement(ItemEntity entity) {
                        property.itemMovement(entity);
                    }

                    @Nullable
                    public PathType getBlockPathType(FluidState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, boolean canFluidLog) {
                        return canFluidLog ? super.getBlockPathType(state, level, pos, mob, true) : null;
                    }

                    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                        consumer.accept(new IClientFluidTypeExtensions(){
                            private static final ResourceLocation UNDERWATER_LOCATION = VersionHelper.toLoc("textures/misc/underwater.png");

                            public ResourceLocation getStillTexture() {
                                return property.stillTexture();
                            }

                            public ResourceLocation getFlowingTexture() {
                                return property.flowingTexture();
                            }

                            @Nullable
                            public ResourceLocation getOverlayTexture() {
                                return property.overlayTexture();
                            }

                            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                                return UNDERWATER_LOCATION;
                            }

                            public int getTintColor() {
                                return property.tintColor();
                            }

                            public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                                return property.tintColor(state, getter, pos);
                            }
                        });
                    }
                };
                RegistryObject type = FLUIDTYPE.register(property.name().getPath(), () -> TYPE);
                after.add(() -> {
                    for (Supplier f : fluid) {
                        FluidProperties.fluidProps.put((Fluid)f.get(), property);
                        fluidTypes.put((Fluid)f.get(), (RegistryObject<FluidType>)type);
                    }
                });
            }
        });
        FLUIDTYPE.register(this.eventBus());
        mod.setupConfigs(new ConfigCollector(){

            @Override
            public void registerConfig(ConfigObject configObject) {
                ConfigBuilder.registerConfig(mod, configObject);
            }

            @Override
            public void registerConfig(Class<?> configClass) {
                ConfigBuilder.registerConfig(mod, configClass);
            }
        });
        if (mod instanceof PacketHolder) {
            UnionLib.debug("Registering packets on server for mod: " + mod.getModid());
            if (mod.getLoadType() == MinecraftMod.LoadType.BOTH) {
                final SimpleProtocol builder = ChannelBuilder.named((ResourceLocation)(((PacketHolder)((Object)mod)).channelName() == null ? mod.location("main_simple_channel") : ((PacketHolder)((Object)mod)).channelName())).networkProtocolVersion(0).optional().simpleChannel().play();
                final MutableObject appendable = new MutableObject(null);
                ((PacketHolder)((Object)mod)).registerPackets(new PacketCollector(){
                    boolean startedServerbound = false;
                    boolean startedClientbound = false;

                    @Override
                    public <T extends ServerboundUnionPacket> void registerServerboundPacket(ResourceLocation id, Class<T> messageType, Function<RegistryFriendlyByteBuf, T> decoder) {
                        if (appendable.getValue() == null) {
                            appendable.setValue((Object)((SimpleFlow)builder.serverbound()));
                            this.startedServerbound = true;
                        }
                        if (!this.startedServerbound) {
                            appendable.setValue((Object)((SimpleFlow)((SimpleFlow)appendable.getValue()).serverbound()));
                            this.startedServerbound = true;
                        }
                        appendable.setValue(PlatformHelper.registerMessage((SimpleFlow<RegistryFriendlyByteBuf, Object>)((SimpleFlow)appendable.getValue()), messageType, decoder));
                    }

                    @Override
                    public <T extends ClientboundUnionPacket> void registerClientboundPacket(ResourceLocation id, Class<T> messageType, Function<RegistryFriendlyByteBuf, T> decoder) {
                        if (appendable.getValue() == null) {
                            appendable.setValue((Object)((SimpleFlow)builder.clientbound()));
                            this.startedClientbound = true;
                        }
                        if (!this.startedClientbound) {
                            appendable.setValue((Object)((SimpleFlow)((SimpleFlow)appendable.getValue()).clientbound()));
                            this.startedClientbound = true;
                        }
                        appendable.setValue(PlatformHelper.registerMessage((SimpleFlow<RegistryFriendlyByteBuf, Object>)((SimpleFlow)appendable.getValue()), messageType, decoder));
                    }
                });
                if (mod.channel == null) {
                    mod.channel = ((SimpleFlow)appendable.getValue()).build();
                }
                UnionLib.debug(mod.getModid() + "'s Serverbound & Clientbound packets registered");
            } else {
                UnionLib.debug("Not registering " + mod.getModid() + "'s Serverbound packets Because [This: -> " + String.valueOf((Object)mod.getLoadType()) + " <- Game: -> " + String.valueOf((Object)ModHandler.getLoadState()) + " <-]");
            }
        }
        this.eventBus().addListener(commonEvent -> mod.onModStartup());
        this.eventBus().addListener(event -> mod.setupPacks(new PackCollector(){
            final /* synthetic */ AddPackFindersEvent val$event;
            final /* synthetic */ MinecraftMod val$mod;
            {
                this.val$event = addPackFindersEvent;
                this.val$mod = minecraftMod;
            }

            @Override
            public void addPack(String packLocation, Component description, PackType packType) {
                if (this.val$event.getPackType() == packType) {
                    this.val$event.addRepositorySource(packConsumer -> {
                        String packName = packLocation.replace("/", "_");
                        Pack pack = Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo(this.val$mod.getModid() + ":" + packName, description, PackSource.DEFAULT, Optional.empty()), (Pack.ResourcesSupplier)new PathPackResources.PathResourcesSupplier(ModList.get().getModFileById(this.val$mod.getModid()).getFile().findResource(packLocation.split("/"))), (PackType)packType, (PackSelectionConfig)new PackSelectionConfig(true, Pack.Position.TOP, false));
                        if (pack == null) {
                            throw new RuntimeException("Couldn't find pack " + packName);
                        }
                        packConsumer.accept(pack);
                    });
                }
            }
        }));
        this.eventBus().addListener(clientEvent -> after.forEach(Runnable::run));
        if (mod.getLoadType() == MinecraftMod.LoadType.BOTH) {
            MinecraftForge.EVENT_BUS.addListener(event -> mod.setupBrewingRecipes(new BrewingRecipeCollector(){
                final /* synthetic */ BrewingRecipeRegisterEvent val$event;
                {
                    this.val$event = brewingRecipeRegisterEvent;
                }

                @Override
                public PotionBrewing.Builder builder() {
                    return this.val$event.getBuilder();
                }

                @Override
                public void addMix(Housing<Potion> input, Item reagent, Housing<Potion> result) {
                    this.val$event.getBuilder().addMix(input.holder(), reagent, result.holder());
                }

                @Override
                public void addMix(Holder<Potion> input, Item reagent, Housing<Potion> result) {
                    this.val$event.getBuilder().addMix(input, reagent, result.holder());
                }

                @Override
                public void addMix(Housing<Potion> input, Item reagent, Holder<Potion> result) {
                    this.val$event.getBuilder().addMix(input.holder(), reagent, result);
                }

                @Override
                public void addMix(Holder<Potion> input, Item reagent, Holder<Potion> result) {
                    this.val$event.getBuilder().addMix(input, reagent, result);
                }
            }));
        }
        MinecraftForge.EVENT_BUS.addListener(event -> ((MinecraftMod)this).setupCommands(new CommandCollector(){
            final /* synthetic */ RegisterCommandsEvent val$event;
            {
                this.val$event = registerCommandsEvent;
            }

            @Override
            public Commands.CommandSelection selection() {
                return this.val$event.getCommandSelection();
            }

            @Override
            public CommandDispatcher<CommandSourceStack> dispatcher() {
                return this.val$event.getDispatcher();
            }

            @Override
            public CommandBuildContext context() {
                return this.val$event.getBuildContext();
            }
        }));
    }

    public void clientStuff() {
        MinecraftMod mod = (MinecraftMod)this;
        this.eventBus().addListener(clientEvent -> {
            mod.onModStartupInClient();
            mod.getClientSegment().setupRenderLayers(new RenderLayerCollector(this){

                @Override
                public void setItemRenderLayer(RenderType renderLayer, Item ... items) {
                    for (Item item : items) {
                        ItemBlockRenderTypes.setRenderLayer((Block)Block.byItem((Item)item), (RenderType)renderLayer);
                    }
                }

                @Override
                public void setFluidRenderLayer(RenderType renderLayer, Fluid ... fluids) {
                    for (Fluid fluid : fluids) {
                        ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)renderLayer);
                    }
                }

                @Override
                public void setBlockRenderLayer(RenderType renderLayer, Block ... blocks) {
                    for (Block block : blocks) {
                        ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderLayer);
                    }
                }
            });
        });
        this.eventBus().addListener(clientEvent -> {
            mod.onModStartupInClient();
            if (mod.getClientSegment() != null) {
                mod.getClientSegment().setupMenus(new MenuCollector(this){

                    @Override
                    public <M extends AbstractContainerMenu, U extends Screen> void addMenu(MenuType<? extends M> pType, MenuScreens.ScreenConstructor<M, U> pFactory) {
                        MenuScreens.register(pType, pFactory);
                    }
                });
            }
        });
        this.eventBus().addListener(blockColorEvent -> {
            if (mod.getClientSegment() != null) {
                mod.getClientSegment().setupColorOverrides(new ColorOverrideCollector(){
                    final /* synthetic */ RegisterColorHandlersEvent.Block val$blockColorEvent;
                    {
                        this.val$blockColorEvent = block;
                    }

                    @Override
                    public void overrideBlocks(BlockColor color, Block ... blocks) {
                        this.val$blockColorEvent.register(color, blocks);
                    }

                    @Override
                    public void overrideItems(ItemColor color, Item ... items) {
                    }
                });
            }
        });
        this.eventBus().addListener(itemColorEvent -> {
            if (mod.getClientSegment() != null) {
                mod.getClientSegment().setupColorOverrides(new ColorOverrideCollector(){
                    final /* synthetic */ RegisterColorHandlersEvent.Item val$itemColorEvent;
                    {
                        this.val$itemColorEvent = item;
                    }

                    @Override
                    public void overrideItems(ItemColor color, Item ... items) {
                        this.val$itemColorEvent.register(color, (ItemLike[])items);
                    }

                    @Override
                    public void overrideBlocks(BlockColor color, Block ... blocks) {
                    }
                });
            }
        });
        this.eventBus().addListener(mapEvent -> ((MinecraftMod)this).getClientSegment().setupKeymappings(arg_0 -> ((RegisterKeyMappingsEvent)mapEvent).register(arg_0)));
        this.eventBus().addListener(particleEvent -> ((MinecraftMod)this).getClientSegment().setupParticles(new ParticleCollector(){
            final /* synthetic */ RegisterParticleProvidersEvent val$particleEvent;
            {
                this.val$particleEvent = registerParticleProvidersEvent;
            }

            @Override
            public void addTexture(ResourceLocation particle) {
            }

            @Override
            public <T extends ParticleOptions> void addFactory(ParticleType<T> type, ParticleEngine.SpriteParticleRegistration<T> registration) {
                this.val$particleEvent.registerSpriteSet(type, registration);
            }
        }));
    }

    public String NETWORK_PROTOCOL_VERSION() {
        return "1";
    }

    public String getVersion() {
        if (this.getModInfo() != null) {
            return MavenVersionStringHelper.artifactVersionToString((ArtifactVersion)this.getModInfo().getVersion());
        }
        return "???";
    }

    public IModInfo getModInfo() {
        Mutable<IModInfo> modInfo = new Mutable<IModInfo>(this){
            IModInfo modInfo;

            public void setValue(IModInfo value) {
                this.modInfo = value;
            }

            public IModInfo getValue() {
                return this.modInfo;
            }
        };
        ModList.get().getMods().forEach(arg_0 -> this.lambda$getModInfo$11((Mutable)modInfo, arg_0));
        return (IModInfo)modInfo.getValue();
    }

    public void setupConfigScreen(ClientSegment client) {
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(client::getConfigScreen));
    }

    private /* synthetic */ void lambda$getModInfo$11(Mutable modInfo, IModInfo mod) {
        if (mod.getModId() == this.getModid()) {
            modInfo.setValue((Object)mod);
        }
    }
}

