/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.mixin;

import com.stereowalker.unionlib.world.entity.player.CustomInventoryGetter;
import com.stereowalker.unionlib.world.entity.player.UnionInventory;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements CustomInventoryGetter {
    private UnionInventory uInv = new UnionInventory((Player)this);

    private PlayerMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Override
    public UnionInventory getUnionInventory() {
        return this.uInv;
    }

    @Override
    public void setUnionInventory(UnionInventory inv) {
        this.uInv = inv;
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    public void aiStep_inject(CallbackInfo ci) {
        this.getUnionInventory().tick();
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData_inject(CompoundTag pCompound, CallbackInfo ci) {
        pCompound.put("UnionInventory", (Tag)this.uInv.save((HolderLookup.Provider)this.registryAccess()));
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData_inject(CompoundTag pCompound, CallbackInfo ci) {
        ListTag listtag = pCompound.getList("UnionInventory", 10);
        this.uInv.load(listtag, (HolderLookup.Provider)this.registryAccess());
    }

    @Inject(method={"dropEquipment"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;dropAll()V")})
    public void dropEquipment_inject(CallbackInfo ci) {
        this.uInv.dropAll();
    }

    @Inject(method={"destroyVanishingCursedItems"}, at={@At(value="TAIL")})
    public void destroyVanishingCursedItems_inject(CallbackInfo ci) {
        for (int i = 0; i < this.uInv.getContainerSize(); ++i) {
            ItemStack itemstack = this.uInv.getItem(i);
            if (itemstack.isEmpty() || !EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            this.uInv.removeItemNoUpdate(i);
        }
    }
}

