/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.mixin.client;

import com.stereowalker.unionlib.api.collectors.OverlayCollector;
import com.stereowalker.unionlib.client.gui.GuiRendererImpl;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.ModHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.LayeredDraw;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class GuiMixin {
    @Shadow
    @Final
    private LayeredDraw layers;
    private boolean hasSetUp = false;

    @Inject(method={"resetTitleTimes"}, at={@At(value="HEAD")})
    public void initInjectHead(CallbackInfo ci) {
        if (!this.hasSetUp) {
            final Gui gui = (Gui)this;
            for (MinecraftMod mod : ModHandler.mods.values()) {
                mod.getClientSegment().setupGuiOverlays(new OverlayCollector(){

                    @Override
                    public void register(String id, OverlayCollector.Order order, OverlayCollector.Overlay overlay) {
                        if (order == OverlayCollector.Order.START) {
                            GuiMixin.this.layers.add((guiGraphics, b) -> overlay.render(gui, new GuiRendererImpl(guiGraphics, b.getGameTimeDeltaPartialTick(false)), guiGraphics.guiWidth(), guiGraphics.guiHeight()));
                        }
                    }
                });
            }
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void initInjectTail(Minecraft pMinecraft, CallbackInfo ci) {
        final Gui gui = (Gui)this;
        for (MinecraftMod mod : ModHandler.mods.values()) {
            mod.getClientSegment().setupGuiOverlays(new OverlayCollector(){

                @Override
                public void register(String id, OverlayCollector.Order order, OverlayCollector.Overlay overlay) {
                    if (order == OverlayCollector.Order.END) {
                        GuiMixin.this.layers.add((guiGraphics, b) -> overlay.render(gui, new GuiRendererImpl(guiGraphics, b.getGameTimeDeltaPartialTick(false)), guiGraphics.guiWidth(), guiGraphics.guiHeight()));
                    }
                }
            });
        }
    }
}

