/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.util;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;

public class GeneralUtilities {
    public static <T extends WeightedObject> T getRandomFrom(Collection<T> objects, Predicate<T> conditions) {
        List<WeightedObject> objectList = conditions == null ? objects.stream().collect(Collectors.toList()) : objects.stream().filter(conditions).collect(Collectors.toList());
        if (objectList.size() > 0) {
            MutableInt totalWeight = new MutableInt();
            objectList.forEach(item -> totalWeight.add(item.getWeight()));
            int i = 0;
            int j = new Random().nextInt(totalWeight.intValue());
            for (WeightedObject object : objectList) {
                if ((i += object.getWeight()) < j) continue;
                return (T)object;
            }
            System.out.println("Was unable to generate a random item. returning the first item");
            return (T)((WeightedObject)objectList.get(0));
        }
        return null;
    }

    public static interface WeightedObject {
        public int getWeight();
    }
}

