/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.util;

import com.stereowalker.unionlib.api.registries.RegistryWrapper;
import com.stereowalker.unionlib.core.registries.RegistryWrapImpl;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class RegistryHelper {
    public static ResourceKey<Registry<Attribute>> attributeKey() {
        return Registries.ATTRIBUTE;
    }

    public static ResourceKey<Registry<Block>> blockKey() {
        return Registries.BLOCK;
    }

    public static ResourceKey<Registry<EntityType<?>>> entityTypeKey() {
        return Registries.ENTITY_TYPE;
    }

    public static ResourceKey<Registry<Fluid>> fluidKey() {
        return Registries.FLUID;
    }

    public static ResourceKey<Registry<Item>> itemKey() {
        return Registries.ITEM;
    }

    public static ResourceKey<Registry<ParticleType<?>>> particleTypeKey() {
        return Registries.PARTICLE_TYPE;
    }

    public static ResourceKey<Registry<Potion>> potionKey() {
        return Registries.POTION;
    }

    public static ResourceLocation getAttributeKey(Attribute v) {
        return RegistryHelper.attributes().getKey((Object)v);
    }

    public static ResourceLocation getBlockKey(Block v) {
        return RegistryHelper.blocks().getKey((Object)v);
    }

    public static ResourceLocation getEntityTypeKey(EntityType<?> v) {
        return RegistryHelper.entityTypes().getKey(v);
    }

    public static ResourceLocation getFluidKey(Fluid v) {
        return RegistryHelper.fluids().getKey((Object)v);
    }

    public static ResourceLocation getItemKey(Item v) {
        return RegistryHelper.items().getKey((Object)v);
    }

    public static ResourceLocation getParticleTypeKey(ParticleType<?> v) {
        return RegistryHelper.particleTypes().getKey(v);
    }

    public static ResourceLocation getPotionKey(Potion v) {
        return RegistryHelper.potions().getKey((Object)v);
    }

    public static Attribute getAttribute(ResourceLocation v) {
        return (Attribute)RegistryHelper.attributes().get(v);
    }

    public static Block getBlock(ResourceLocation v) {
        return (Block)RegistryHelper.blocks().get(v);
    }

    public static EntityType<?> getEntityType(ResourceLocation v) {
        return (EntityType)RegistryHelper.entityTypes().get(v);
    }

    public static Fluid getFluid(ResourceLocation v) {
        return (Fluid)RegistryHelper.fluids().get(v);
    }

    public static Item getItem(ResourceLocation v) {
        return (Item)RegistryHelper.items().get(v);
    }

    public static ParticleType<?> getParticleType(ResourceLocation v) {
        return (ParticleType)RegistryHelper.particleTypes().get(v);
    }

    public static Potion getPotion(ResourceLocation v) {
        return (Potion)RegistryHelper.potions().get(v);
    }

    public static Registry<Attribute> attributes() {
        return BuiltInRegistries.ATTRIBUTE;
    }

    public static Registry<Block> blocks() {
        return BuiltInRegistries.BLOCK;
    }

    public static Registry<EntityType<?>> entityTypes() {
        return BuiltInRegistries.ENTITY_TYPE;
    }

    public static Registry<Item> items() {
        return BuiltInRegistries.ITEM;
    }

    public static Registry<ParticleType<?>> particleTypes() {
        return BuiltInRegistries.PARTICLE_TYPE;
    }

    public static Registry<Potion> potions() {
        return BuiltInRegistries.POTION;
    }

    public static Registry<Fluid> fluids() {
        return BuiltInRegistries.FLUID;
    }

    public static boolean matchesRegistryKey(ResourceLocation name, ResourceKey<?> key) {
        return name.toString().equalsIgnoreCase(key.location().toString());
    }

    public static <V> RegistryWrapper<V> createWrapper() {
        return new RegistryWrapImpl();
    }

    public static <T extends Enum<?>> T rotateEnumForward(T input, T[] values) {
        if (input.ordinal() == values.length - 1) {
            return values[0];
        }
        return values[input.ordinal() + 1];
    }

    public static <T extends Enum<?>> T rotateEnumBackward(T input, T[] values) {
        if (input.ordinal() == values.length - 1) {
            return values[0];
        }
        return values[input.ordinal() + 1];
    }
}

