/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.world.entity.player;

import com.stereowalker.unionlib.world.entity.AccessorySlot;
import com.stereowalker.unionlib.world.item.AccessoryItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class UnionInventory
extends SimpleContainer {
    public final Player player;

    public UnionInventory(Player player) {
        super(9);
        this.player = player;
    }

    public void load(ListTag p_70486_1_, HolderLookup.Provider pLevelRegistry) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.setItem(i, ItemStack.EMPTY);
        }
        for (int k = 0; k < p_70486_1_.size(); ++k) {
            CompoundTag compoundtag = p_70486_1_.getCompound(k);
            int j = compoundtag.getByte("Slot") & 0xFF;
            if (j < 0 || j >= this.getContainerSize()) continue;
            this.setItem(j, ItemStack.parse((HolderLookup.Provider)pLevelRegistry, (Tag)compoundtag).orElse(ItemStack.EMPTY));
        }
    }

    public ListTag save(HolderLookup.Provider pLevelRegistry) {
        ListTag pNbtTagList = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemstack = this.getItem(i);
            if (itemstack.isEmpty()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.putByte("Slot", (byte)i);
            pNbtTagList.add((Object)itemstack.save(pLevelRegistry, (Tag)compoundtag));
        }
        return pNbtTagList;
    }

    public void tick() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItem(i).isEmpty() || !(this.getItem(i).getItem() instanceof AccessoryItem)) continue;
            ((AccessoryItem)this.getItem(i).getItem()).accessoryTick(this.player.level(), (LivingEntity)this.player, this.getItem(i), i);
        }
    }

    public void dropAll() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemstack = this.getItem(i);
            if (itemstack.isEmpty()) continue;
            this.player.drop(itemstack, true, false);
            this.setItem(i, ItemStack.EMPTY);
        }
    }

    public void replaceWith(UnionInventory playerInventory) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.setItem(i, playerInventory.getItem(i));
        }
    }

    public boolean isUsableByPlayer(Player player) {
        return true;
    }

    public ItemStack getAccessory(AccessorySlot slot) {
        return this.getItem(slot.getIndex());
    }

    @Deprecated
    public ItemStack getFirstRing() {
        return this.getItem(3);
    }

    @Deprecated
    public ItemStack getSecondRing() {
        return this.getItem(6);
    }
}

