/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.world.item.component;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import com.stereowalker.unionlib.world.entity.AccessorySlotGroup;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public record AccessoryAttributeModifiers(List<Entry> modifiers, boolean showInTooltip) {
    public static final AccessoryAttributeModifiers EMPTY = new AccessoryAttributeModifiers(List.of(), true);
    private static final Codec<AccessoryAttributeModifiers> FULL_CODEC = RecordCodecBuilder.create(p_333950_ -> p_333950_.group((App)Entry.CODEC.listOf().fieldOf("modifiers").forGetter(AccessoryAttributeModifiers::modifiers), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(AccessoryAttributeModifiers::showInTooltip)).apply((Applicative)p_333950_, AccessoryAttributeModifiers::new));
    public static final Codec<AccessoryAttributeModifiers> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)Entry.CODEC.listOf(), p_331984_ -> new AccessoryAttributeModifiers((List<Entry>)p_331984_, true));
    public static final StreamCodec<RegistryFriendlyByteBuf, AccessoryAttributeModifiers> STREAM_CODEC = StreamCodec.composite((StreamCodec)Entry.STREAM_CODEC.apply(ByteBufCodecs.list()), AccessoryAttributeModifiers::modifiers, (StreamCodec)ByteBufCodecs.BOOL, AccessoryAttributeModifiers::showInTooltip, AccessoryAttributeModifiers::new);
    public static final DecimalFormat ATTRIBUTE_MODIFIER_FORMAT = (DecimalFormat)Util.make((Object)new DecimalFormat("#.##"), p_334862_ -> p_334862_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    public AccessoryAttributeModifiers withTooltip(boolean pShowInTooltip) {
        return new AccessoryAttributeModifiers(this.modifiers, pShowInTooltip);
    }

    public static Builder builder() {
        return new Builder();
    }

    public AccessoryAttributeModifiers withModifierAdded(Holder<Attribute> pAttribute, AttributeModifier pModifier, AccessorySlotGroup pSlot) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        for (Entry AccessoryAttributeModifiers$entry : this.modifiers) {
            if (AccessoryAttributeModifiers$entry.modifier.id().equals((Object)pModifier.id())) continue;
            builder.add((Object)AccessoryAttributeModifiers$entry);
        }
        builder.add((Object)new Entry(pAttribute, pModifier, pSlot));
        return new AccessoryAttributeModifiers((List<Entry>)builder.build(), this.showInTooltip);
    }

    public void forEach(AccessorySlot pEquipmentSlot, BiConsumer<Holder<Attribute>, AttributeModifier> pAction) {
        for (Entry AccessoryAttributeModifiers$entry : this.modifiers) {
            if (!AccessoryAttributeModifiers$entry.slot.test(pEquipmentSlot)) continue;
            pAction.accept(AccessoryAttributeModifiers$entry.attribute, AccessoryAttributeModifiers$entry.modifier);
        }
    }

    public void forEach(AccessorySlotGroup pEquipmentSlot, BiConsumer<Holder<Attribute>, AttributeModifier> pAction) {
        for (Entry AccessoryAttributeModifiers$entry : this.modifiers) {
            if (AccessoryAttributeModifiers$entry.slot != pEquipmentSlot) continue;
            pAction.accept(AccessoryAttributeModifiers$entry.attribute, AccessoryAttributeModifiers$entry.modifier);
        }
    }

    public double compute(double pBaseValue, AccessorySlot pEquipmentSlot) {
        double d0 = pBaseValue;
        for (Entry AccessoryAttributeModifiers$entry : this.modifiers) {
            if (!AccessoryAttributeModifiers$entry.slot.test(pEquipmentSlot)) continue;
            double d1 = AccessoryAttributeModifiers$entry.modifier.amount();
            d0 += (switch (AccessoryAttributeModifiers$entry.modifier.operation()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.ADD_VALUE -> d1;
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> d1 * pBaseValue;
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> d1 * d0;
            });
        }
        return d0;
    }

    public static class Builder {
        private final ImmutableList.Builder<Entry> entries = ImmutableList.builder();

        Builder() {
        }

        public Builder add(Holder<Attribute> pAttribute, AttributeModifier pModifier, AccessorySlotGroup pSlot) {
            this.entries.add((Object)new Entry(pAttribute, pModifier, pSlot));
            return this;
        }

        public AccessoryAttributeModifiers build() {
            return new AccessoryAttributeModifiers((List<Entry>)this.entries.build(), true);
        }
    }

    public record Entry(Holder<Attribute> attribute, AttributeModifier modifier, AccessorySlotGroup slot) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(p_327889_ -> p_327889_.group((App)BuiltInRegistries.ATTRIBUTE.holderByNameCodec().fieldOf("type").forGetter(Entry::attribute), (App)AttributeModifier.MAP_CODEC.forGetter(Entry::modifier), (App)AccessorySlotGroup.CODEC.optionalFieldOf("slot", (Object)AccessorySlotGroup.ANY).forGetter(Entry::slot)).apply((Applicative)p_327889_, Entry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ATTRIBUTE), Entry::attribute, (StreamCodec)AttributeModifier.STREAM_CODEC, Entry::modifier, AccessorySlotGroup.STREAM_CODEC, Entry::slot, Entry::new);
    }
}

