/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.config;

import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.util.toml.TomlWriter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ConfigHolder<T> {
    private T cachedValue;
    private boolean hasInitialized = false;
    protected final String name;
    protected final TomlWriter value;
    protected final T defaultValue;
    protected final String parentFile;
    protected final List<class_2561> comments;
    protected final boolean usesSlider;
    protected final T min;
    protected final T max;
    protected final String translatable;
    protected final String[] translatableComment;
    protected boolean recievedChanges;

    public ConfigHolder(String name, TomlWriter configvalue, T defaultValue, String parentFile, List<class_2561> comments, boolean usesSlider, T min, T max, String translatable, String[] translatableComment) {
        this.name = name;
        this.comments = comments;
        this.value = configvalue;
        this.parentFile = parentFile;
        this.defaultValue = defaultValue;
        this.usesSlider = usesSlider;
        this.min = min;
        this.max = max;
        this.translatable = translatable;
        this.translatableComment = translatableComment;
    }

    public T get() {
        if (this.hasInitialized) {
            return this.cachedValue;
        }
        System.out.println("Using Legacy To Get Value " + String.valueOf(this.cachedValue == null ? "null" : this.cachedValue.getClass()));
        if (this.cachedValue == null) {
            UnionLib.debug("Cached value is null, returning default");
            return this.defaultValue;
        }
        return this.cachedValue;
    }

    public void set(T newValue) {
        Number newNumber;
        if (newValue instanceof Number && (newNumber = (Number)newValue).doubleValue() < ((Number)this.min).doubleValue()) {
            newValue = this.min;
        }
        if (newValue instanceof Number && (newNumber = (Number)newValue).doubleValue() > ((Number)this.max).doubleValue()) {
            newValue = this.max;
        }
        this.value.update(this.name, newValue);
        if (!newValue.equals(this.cachedValue) && this.hasInitialized) {
            this.recievedChanges = true;
        }
        this.cachedValue = newValue;
    }

    public void update(T newValue) {
        this.set(newValue);
        this.hasInitialized = true;
    }

    public void setValue(T newValue) {
        this.set(newValue);
        this.value.buildToFile();
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String getParentFile() {
        return this.parentFile;
    }

    public List<class_2561> getComments() {
        return this.comments;
    }

    public String nameInQuotes() {
        String[] na = this.name.split("\\.");
        Object result = "";
        boolean includedDot = false;
        for (String s : na) {
            result = (String)result + (includedDot ? "." : "") + "\"" + s + "\"";
            includedDot = true;
        }
        return result;
    }

    public List<class_2561> getTranslatableComments() {
        ArrayList<class_2561> translated = new ArrayList<class_2561>();
        if (this.translatableComment.length > 0) {
            for (String translate : this.translatableComment) {
                String[] split;
                class_5250 comments = class_2561.method_43471((String)translate);
                if (comments.getString().length() <= 0) continue;
                for (String s : split = comments.getString().split("\n")) {
                    translated.add((class_2561)class_2561.method_43470((String)s).method_27692(class_124.field_1075));
                }
            }
        }
        if (translated.size() > 0) {
            this.comments.forEach(comment -> {
                if (class_124.field_1054.method_532().equals(comment.method_10866().method_10973().method_27716())) {
                    translated.add((class_2561)comment);
                }
                if (class_124.field_1060.method_532().equals(comment.method_10866().method_10973().method_27716())) {
                    translated.add((class_2561)comment);
                }
            });
        }
        return translated;
    }

    public boolean isUsingSlider() {
        return this.usesSlider;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public String getTranslatable() {
        return this.translatable;
    }
}

