/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.supporter;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.stereowalker.unionlib.client.model.HatModel;
import com.stereowalker.unionlib.supporter.Cosmetics;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_5607;
import net.minecraft.class_630;

public class Cosmetic {
    String id;
    String model;
    boolean showOnHelmet;
    int height;
    List<String> segments;
    class_5607 layerDefinition;
    Map<String, String> textureUrl;
    Map<String, class_2960> texture;
    private Map<String, CompletableFuture<class_2960>> textureFuture;

    protected Cosmetic(String id, boolean showOnHelmet, int heightOffset, String model, Map<String, String> textureUrl, List<String> segments) {
        this.id = id;
        this.showOnHelmet = showOnHelmet;
        this.height = heightOffset;
        this.model = model;
        this.textureUrl = textureUrl;
        this.segments = segments;
        this.texture = new HashMap<String, class_2960>();
        this.textureFuture = new HashMap<String, CompletableFuture<class_2960>>();
    }

    public class_630 bakeLayer() {
        if (this.layerDefinition == null) {
            this.layerDefinition = HatModel.createBodyLayer(this.id, this.model);
        }
        return this.layerDefinition.method_32109();
    }

    public String model() {
        return this.model;
    }

    public String id() {
        return this.id;
    }

    public List<String> variants() {
        return this.textureUrl.keySet().stream().filter(var -> !var.contains("custom_")).sorted(Comparator.comparing(s -> s.equals("base")).reversed()).collect(Collectors.toList());
    }

    public List<String> segments() {
        return this.segments;
    }

    public int renderHeightOffset() {
        return this.height;
    }

    public boolean showOnHelmet() {
        return this.showOnHelmet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public class_2960 texture(String variant) {
        if (!this.textureUrl.containsKey(variant) || this.textureUrl.get(variant).isEmpty()) {
            return null;
        }
        if (this.texture.containsKey(variant)) {
            return this.texture.get(variant);
        }
        Cosmetic cosmetic = this;
        synchronized (cosmetic) {
            if (!this.textureFuture.containsKey(variant)) {
                this.textureFuture.put(variant, (CompletableFuture<class_2960>)Cosmetics.cosmeticTextures.getOrLoad(new MinecraftProfileTexture(this.textureUrl.get(variant), null)).whenComplete((loc, err) -> {
                    if (err != null) {
                        err.printStackTrace();
                    } else {
                        this.texture.put(variant, (class_2960)loc);
                    }
                }));
            }
        }
        return VersionHelper.toLoc("unionlib", "textures/cosmetics/head_preview.png");
    }
}

