/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.world.item.component;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import com.stereowalker.unionlib.world.entity.AccessorySlotGroup;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_156;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record AccessoryAttributeModifiers(List<Entry> modifiers, boolean showInTooltip) {
    public static final AccessoryAttributeModifiers EMPTY = new AccessoryAttributeModifiers(List.of(), true);
    private static final Codec<AccessoryAttributeModifiers> FULL_CODEC = RecordCodecBuilder.create(p_333950_ -> p_333950_.group((App)Entry.CODEC.listOf().fieldOf("modifiers").forGetter(AccessoryAttributeModifiers::modifiers), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(AccessoryAttributeModifiers::showInTooltip)).apply((Applicative)p_333950_, AccessoryAttributeModifiers::new));
    public static final Codec<AccessoryAttributeModifiers> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)Entry.CODEC.listOf(), p_331984_ -> new AccessoryAttributeModifiers((List<Entry>)p_331984_, true));
    public static final class_9139<class_9129, AccessoryAttributeModifiers> STREAM_CODEC = class_9139.method_56435((class_9139)Entry.STREAM_CODEC.method_56433(class_9135.method_56363()), AccessoryAttributeModifiers::modifiers, (class_9139)class_9135.field_48547, AccessoryAttributeModifiers::showInTooltip, AccessoryAttributeModifiers::new);
    public static final DecimalFormat ATTRIBUTE_MODIFIER_FORMAT = (DecimalFormat)class_156.method_654((Object)new DecimalFormat("#.##"), p_334862_ -> p_334862_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    public AccessoryAttributeModifiers withTooltip(boolean pShowInTooltip) {
        return new AccessoryAttributeModifiers(this.modifiers, pShowInTooltip);
    }

    public static Builder builder() {
        return new Builder();
    }

    public AccessoryAttributeModifiers withModifierAdded(class_6880<class_1320> pAttribute, class_1322 pModifier, AccessorySlotGroup pSlot) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        for (Entry AccessoryAttributeModifiers$entry : this.modifiers) {
            if (AccessoryAttributeModifiers$entry.modifier.comp_2447().equals((Object)pModifier.comp_2447())) continue;
            builder.add((Object)AccessoryAttributeModifiers$entry);
        }
        builder.add((Object)new Entry(pAttribute, pModifier, pSlot));
        return new AccessoryAttributeModifiers((List<Entry>)builder.build(), this.showInTooltip);
    }

    public void forEach(AccessorySlot pEquipmentSlot, BiConsumer<class_6880<class_1320>, class_1322> pAction) {
        for (Entry AccessoryAttributeModifiers$entry : this.modifiers) {
            if (!AccessoryAttributeModifiers$entry.slot.test(pEquipmentSlot)) continue;
            pAction.accept(AccessoryAttributeModifiers$entry.attribute, AccessoryAttributeModifiers$entry.modifier);
        }
    }

    public void forEach(AccessorySlotGroup pEquipmentSlot, BiConsumer<class_6880<class_1320>, class_1322> pAction) {
        for (Entry AccessoryAttributeModifiers$entry : this.modifiers) {
            if (AccessoryAttributeModifiers$entry.slot != pEquipmentSlot) continue;
            pAction.accept(AccessoryAttributeModifiers$entry.attribute, AccessoryAttributeModifiers$entry.modifier);
        }
    }

    public double compute(double pBaseValue, AccessorySlot pEquipmentSlot) {
        double d0 = pBaseValue;
        for (Entry AccessoryAttributeModifiers$entry : this.modifiers) {
            if (!AccessoryAttributeModifiers$entry.slot.test(pEquipmentSlot)) continue;
            double d1 = AccessoryAttributeModifiers$entry.modifier.comp_2449();
            d0 += (switch (AccessoryAttributeModifiers$entry.modifier.comp_2450()) {
                default -> throw new MatchException(null, null);
                case class_1322.class_1323.field_6328 -> d1;
                case class_1322.class_1323.field_6330 -> d1 * pBaseValue;
                case class_1322.class_1323.field_6331 -> d1 * d0;
            });
        }
        return d0;
    }

    public static class Builder {
        private final ImmutableList.Builder<Entry> entries = ImmutableList.builder();

        Builder() {
        }

        public Builder add(class_6880<class_1320> pAttribute, class_1322 pModifier, AccessorySlotGroup pSlot) {
            this.entries.add((Object)new Entry(pAttribute, pModifier, pSlot));
            return this;
        }

        public AccessoryAttributeModifiers build() {
            return new AccessoryAttributeModifiers((List<Entry>)this.entries.build(), true);
        }
    }

    public record Entry(class_6880<class_1320> attribute, class_1322 modifier, AccessorySlotGroup slot) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(p_327889_ -> p_327889_.group((App)class_7923.field_41190.method_40294().fieldOf("type").forGetter(Entry::attribute), (App)class_1322.field_49232.forGetter(Entry::modifier), (App)AccessorySlotGroup.CODEC.optionalFieldOf("slot", (Object)AccessorySlotGroup.ANY).forGetter(Entry::slot)).apply((Applicative)p_327889_, Entry::new));
        public static final class_9139<class_9129, Entry> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.method_56383((class_5321)class_7924.field_41251), Entry::attribute, (class_9139)class_1322.field_49233, Entry::modifier, AccessorySlotGroup.STREAM_CODEC, Entry::slot, Entry::new);
    }
}

