/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.supporter;

import com.stereowalker.unionlib.supporter.Cosmetics;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_310;
import net.minecraft.class_640;
import net.minecraft.class_742;
import net.minecraft.class_8685;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapeHandler {
    private static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    private static final Logger logger = LogManager.getLogger((String)"unionlib");

    public static void queuePlayerCapeReplacement(class_742 player) {
        if (CapeHandler.doesPlayerNeedCapeClient(player)) {
            String displayName = player.method_5476().getString();
            if (CapeHandler.willPlayerShowCape(player)) {
                THREAD_POOL.submit(() -> {
                    logger.info("Queueing cape replacement for " + displayName);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        logger.fatal("Cape delay thread for " + displayName + " interrupted");
                        return;
                    }
                    class_310.method_1551().method_5382(() -> CapeHandler.replacePlayerCape(player));
                });
            } else {
                logger.info(displayName + " has decided to not display their custom cape");
            }
        }
    }

    private static void replacePlayerCape(class_742 player) {
        String displayName = player.method_5476().getString();
        class_640 playerInfo = player.method_3123();
        if (playerInfo == null) {
            logger.info("PlayerInfo of " + displayName + " is null. Cannot add cape");
            return;
        }
        class_8685 originalTextures = playerInfo.method_52810();
        class_8685 playerTextures = new class_8685(originalTextures.comp_1626(), originalTextures.comp_1911(), VersionHelper.toLoc("unionlib", "textures/cape/" + Cosmetics.equippedCosmetics().get(player.method_5667()) + ".png"), originalTextures.comp_1628(), originalTextures.comp_1629(), originalTextures.comp_1630());
        playerInfo.field_45607 = () -> playerTextures;
        logger.info("Looking for cape texture at " + VersionHelper.toLoc("unionlib", "textures/cape/" + Cosmetics.equippedCosmetics().get(player.method_5667()) + ".png").method_12832());
        logger.info("Replaced cape of " + displayName);
    }

    public static boolean doesPlayerNeedCapeClient(class_742 player) {
        return Cosmetics.equippedCosmetics().containsKey(player.method_5667());
    }

    public static boolean willPlayerShowCape(class_742 player) {
        return !Cosmetics.equippedCosmetics().getOrDefault(player.method_5667(), "").isEmpty();
    }
}

