/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.supporter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.supporter.Cosmetic;
import com.stereowalker.unionlib.util.LoaderHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1044;
import net.minecraft.class_1046;
import net.minecraft.class_1060;
import net.minecraft.class_1068;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class Cosmetics {
    private static final int timeout = 20000;
    protected static TextureCache cosmeticTextures;
    protected static Cosmetic NONE;
    private static volatile Instant lastPoll;
    private static int pollingTicks;
    private static CompletableFuture<Void> recheckThread;
    private static List<String> OWNED_COSMETICS;
    private static Map<String, Cosmetic> ALL_COSMETICS;
    private static Map<UUID, String> EQUIPPED_COSMETICS;

    public static Map<String, Cosmetic> allCosmetics() {
        return ALL_COSMETICS;
    }

    public static Map<UUID, String> equippedCosmetics() {
        return EQUIPPED_COSMETICS;
    }

    public static List<String> ownedCosmetics() {
        return OWNED_COSMETICS;
    }

    public static boolean isEmpty(Cosmetic cosmetic) {
        return cosmetic == NONE;
    }

    public static boolean ownsCosmetic(Cosmetic cosmetic) {
        return OWNED_COSMETICS.contains(cosmetic.id);
    }

    public Cosmetics(class_310 mc) {
        cosmeticTextures = new TextureCache(mc.field_1764, mc.field_1697.toPath().resolve("cosmetics"));
        Cosmetics.obtainAllCosmetics(new File(mc.field_1697, "uacm.db"), true);
    }

    private static void debug(Object message) {
        UnionLib.debug(message);
    }

    private static void populateHeaders(HttpURLConnection connection) {
        String an = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6ImpvY2h6Z3RweWlha2RlaXZmeGVxIiwicm9sZSI6ImFub24iLCJpYXQiOjE3NDcwODk3OTYsImV4cCI6MjA2MjY2NTc5Nn0.PxbO7ns1oSfrHd9FsyRyPlOeXof3_9a6VFgo7sqgB9I";
        connection.setRequestProperty("apikey", an);
        connection.setRequestProperty("Authorization", "Bearer " + an);
    }

    private static void cacheFile(BufferedReader store, File cache) throws IOException {
        store.mark(100000);
        if (!cache.exists()) {
            cache.createNewFile();
        }
        try (PrintWriter printwriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cache), StandardCharsets.UTF_8));){
            store.lines().forEach(line -> printwriter.println((String)line));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        store.reset();
    }

    public static void onConnectToCosmeticDB(Runnable run) {
        CompletableFuture.supplyAsync(() -> {
            boolean fetched = true;
            try {
                URL url = new URI("https://jochzgtpyiakdeivfxeq.supabase.co/rest/v1/cosmetic_eligibility").toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(20000);
                connection.connect();
                Cosmetics.debug("Testing Connection");
            }
            catch (Exception e) {
                fetched = false;
                e.printStackTrace();
            }
            return fetched;
        }).whenComplete((fetched, x) -> {
            if (fetched.booleanValue()) {
                run.run();
            }
        });
    }

    public static void fetchOwnedCosmetics(UUID player, Runnable onFetched) {
        CompletableFuture.supplyAsync(() -> {
            BufferedReader read = null;
            try {
                URL url = new URI(String.format("https://jochzgtpyiakdeivfxeq.supabase.co/rest/v1/cosmetic_eligibility?select=cosmetic_id&expires_at=is.null,gt.now()&player_uuid=eq.%s", player.toString())).toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                Cosmetics.populateHeaders(connection);
                connection.setRequestProperty("x-player-uuid", player.toString());
                connection.setConnectTimeout(20000);
                connection.connect();
                read = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                Cosmetics.debug("Fetching owned cosmetics");
            }
            catch (IOException e) {
                Cosmetics.debug("Internet might not be connected");
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            return read;
        }).whenComplete((read, x) -> {
            if (read != null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                JsonElement element = JsonParser.parseReader((Reader)read);
                element.getAsJsonArray().forEach(elem -> builder.add((Object)elem.getAsJsonObject().get("cosmetic_id").getAsString()));
                OWNED_COSMETICS = builder.build();
                onFetched.run();
                try {
                    read.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void pollCosmetics() {
        if (recheckThread != null && !recheckThread.isDone()) {
            return;
        }
        if (++pollingTicks > 1200) {
            pollingTicks = 0;
            recheckThread = CompletableFuture.runAsync(() -> {
                BufferedReader read = null;
                try {
                    URL url = new URI(String.format("https://jochzgtpyiakdeivfxeq.supabase.co/rest/v1/cosmetic_selection?select=player_uuid,headwear_id,updated_at&updated_at=gt.%s", lastPoll.toString())).toURL();
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    Cosmetics.populateHeaders(connection);
                    connection.setConnectTimeout(20000);
                    connection.connect();
                    read = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    Cosmetics.debug("Rechecking everyone's cosmetics");
                }
                catch (IOException e) {
                    Cosmetics.debug("Internet is not connected");
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                if (read != null) {
                    ImmutableMap.Builder builder = ImmutableMap.builder();
                    builder.putAll(EQUIPPED_COSMETICS);
                    JsonElement element = JsonParser.parseReader(read);
                    element.getAsJsonArray().forEach(elem -> {
                        JsonObject object_2 = elem.getAsJsonObject();
                        String headwear = object_2.get("headwear_id").getAsString();
                        builder.put((Object)UUID.fromString(object_2.get("player_uuid").getAsString()), (Object)headwear);
                    });
                    EQUIPPED_COSMETICS = builder.build();
                    lastPoll = Instant.now();
                    try {
                        read.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).whenComplete((v, x) -> {
                recheckThread = null;
            });
        }
    }

    public static void obtainCosmetics(File cache, boolean createCache) {
        CompletableFuture.runAsync(() -> {
            BufferedReader read = null;
            try {
                URL url = new URI("https://jochzgtpyiakdeivfxeq.supabase.co/rest/v1/cosmetic_selection").toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                Cosmetics.populateHeaders(connection);
                connection.setConnectTimeout(20000);
                connection.connect();
                read = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                Cosmetics.debug("We now know who's wearing what");
                if (createCache) {
                    Cosmetics.cacheFile(read, cache);
                }
            }
            catch (IOException e) {
                Cosmetics.debug("Internet is not connected");
                e.printStackTrace();
                if (cache.exists()) {
                    try {
                        FileInputStream stream = new FileInputStream(cache);
                        InputStreamReader reader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);
                        read = new BufferedReader(reader);
                    }
                    catch (FileNotFoundException e1) {
                        Cosmetics.debug("Cosmetic Cache file not found");
                    }
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            if (read != null) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                JsonElement element = JsonParser.parseReader(read);
                element.getAsJsonArray().forEach(elem -> {
                    JsonObject object_2 = elem.getAsJsonObject();
                    String headwear = object_2.get("headwear_id").getAsString();
                    builder.put((Object)UUID.fromString(object_2.get("player_uuid").getAsString()), (Object)headwear);
                });
                EQUIPPED_COSMETICS = builder.build();
                try {
                    read.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Cosmetics.debug("No cache to load, skipping cosmetics. For now");
            }
        }).whenComplete((v, x) -> {});
    }

    public static boolean updateCosmetic(UUID player, String newHeadwear) {
        try {
            URL url = new URI("https://jochzgtpyiakdeivfxeq.supabase.co/functions/v1/equip-cosmetic").toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            Cosmetics.populateHeaders(connection);
            if (LoaderHelper.isDevEnvironment() && System.getenv("UNIONLIBCOSMETICDEVKEY") != null) {
                connection.setRequestProperty("x-player-uuid", player.toString());
                connection.setRequestProperty("x-dev-secret", System.getenv("UNIONLIBCOSMETICDEVKEY"));
            } else {
                connection.setRequestProperty("mc-ac-token", "Bearer " + class_310.method_1551().method_1548().method_1674());
            }
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Prefer", "resolution=merge-duplicates");
            String payload = "{\"player_uuid\": \"%s\",\"headwear_id\": \"%s\"}".formatted(player, newHeadwear);
            try (OutputStream os = connection.getOutputStream();){
                os.write(payload.getBytes(StandardCharsets.UTF_8));
            }
            int code = connection.getResponseCode();
            boolean success = false;
            if (code >= 200 && code < 300) {
                success = true;
            } else {
                Cosmetics.debug("Failed to change headwear (" + code + ") [" + new String(connection.getErrorStream().readAllBytes(), StandardCharsets.UTF_8) + "]");
            }
            connection.disconnect();
            return success;
        }
        catch (IOException e) {
            Cosmetics.debug("Internet is not connected");
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void obtainAllCosmetics(File cache, boolean createCache) {
        CompletableFuture.runAsync(() -> {
            ImmutableMap.Builder builder;
            BufferedReader read = null;
            try {
                URL url = new URI("https://jochzgtpyiakdeivfxeq.supabase.co/rest/v1/cosmetics?select=*&order=cosmetic_id.asc").toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                Cosmetics.populateHeaders(connection);
                connection.setConnectTimeout(20000);
                connection.connect();
                read = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                Cosmetics.debug("Obtained all cosmetics");
                if (createCache) {
                    Cosmetics.cacheFile(read, cache);
                }
            }
            catch (IOException e) {
                Cosmetics.debug("Internet is not connected");
                e.printStackTrace();
                if (cache.exists()) {
                    try {
                        FileInputStream stream = new FileInputStream(cache);
                        InputStreamReader reader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);
                        read = new BufferedReader(reader);
                    }
                    catch (FileNotFoundException e1) {
                        Cosmetics.debug("Cosmetic Cache file not found");
                    }
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            if (read != null) {
                builder = ImmutableMap.builder();
                JsonElement element = JsonParser.parseReader(read);
                element.getAsJsonArray().forEach(elem -> {
                    JsonObject object_2 = elem.getAsJsonObject();
                    builder.put((Object)object_2.get("cosmetic_id").getAsString(), (Object)new Cosmetic(object_2.get("cosmetic_id").getAsString(), object_2.get("show_with_helmet").getAsBoolean(), object_2.get("height_blocks").getAsInt(), object_2.get("model_dsl").getAsString(), object_2.get("texture_url").getAsString()));
                });
                ALL_COSMETICS = builder.build();
                try {
                    read.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Cosmetics.debug("No cache to load, skipping cosmetics. For now");
            }
            if (ALL_COSMETICS.isEmpty()) {
                builder = ImmutableMap.builder();
                ALL_COSMETICS = builder.put((Object)"", (Object)NONE).build();
            } else {
                NONE = ALL_COSMETICS.get("");
            }
        }).whenComplete((v, x) -> {});
    }

    static {
        NONE = new Cosmetic("", false, 0, "0,0,0><0,0,0,0,0,0,0,0,0", "");
        lastPoll = Instant.now().minusSeconds(60L);
        recheckThread = null;
        OWNED_COSMETICS = new ImmutableList.Builder().add((Object)"").build();
        ALL_COSMETICS = new ImmutableMap.Builder().build();
        EQUIPPED_COSMETICS = new HashMap<UUID, String>();
    }

    static class TextureCache {
        private final class_1060 textureManager;
        private final Path root;
        private final Map<String, CompletableFuture<class_2960>> textures = new Object2ObjectOpenHashMap();

        TextureCache(class_1060 pTextureManager, Path pRoot) {
            this.textureManager = pTextureManager;
            this.root = pRoot;
        }

        public CompletableFuture<class_2960> getOrLoad(MinecraftProfileTexture pTexture) {
            String s = pTexture.getHash();
            CompletableFuture<class_2960> completablefuture = this.textures.get(s);
            if (completablefuture == null) {
                completablefuture = this.registerTexture(pTexture);
                this.textures.put(s, completablefuture);
            }
            return completablefuture;
        }

        private CompletableFuture<class_2960> registerTexture(MinecraftProfileTexture pTexture) {
            String s = Hashing.sha1().hashUnencodedChars((CharSequence)pTexture.getHash()).toString();
            class_2960 resourcelocation = this.getTextureLocation(s);
            Path path = this.root.resolve(s.length() > 2 ? s.substring(0, 2) : "xx").resolve(s);
            CompletableFuture<class_2960> completablefuture = new CompletableFuture<class_2960>();
            class_1046 httptexture = new class_1046(path.toFile(), pTexture.getUrl(), class_1068.method_4649(), false, () -> completablefuture.complete(resourcelocation));
            this.textureManager.method_4616(resourcelocation, (class_1044)httptexture);
            return completablefuture;
        }

        private class_2960 getTextureLocation(String pName) {
            return class_2960.method_60656((String)("cosmetic/" + pName));
        }
    }
}

