/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.stereowalker.unionlib.util.ScreenHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class OverlayImageButton
extends Button {
    private ResourceLocation overlayLocation;
    private final int xTexStart;
    private final int yTexStart;
    private final int xTexStop;
    private final int yTexStop;
    private final int textureWidth;
    private final int textureHeight;
    private ResourceLocation overlayLocation2;
    private final int xTexStart2;
    private final int yTexStart2;
    private final int xTexStop2;
    private final int yTexStop2;
    private final int textureWidth2;
    private final int textureHeight2;
    private float x1;
    private float x2;
    private float y1;
    private float y2;
    private boolean showMessage = false;

    public OverlayImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int xTexStop, int yTexStop, ResourceLocation overlayLocation, int textureWidth, int textureHeight, Button.OnPress onPress, Component title) {
        this(x, y, width, height, xTexStart, yTexStart, xTexStop, yTexStop, overlayLocation, textureWidth, textureHeight, 0, 0, 0, 0, null, 0, 0, onPress, title);
    }

    public OverlayImageButton(int x, int y, int width, int height, int xTexStart1, int yTexStart1, int xTexStop1, int yTexStop1, ResourceLocation overlayLocation1, int textureWidth1, int textureHeight1, int xTexStart2, int yTexStart2, int xTexStop2, int yTexStop2, ResourceLocation overlayLocation2, int textureWidth2, int textureHeight2, Button.OnPress onPress, Component title) {
        super(x, y, width, height, title, onPress, DEFAULT_NARRATION);
        this.xTexStart2 = xTexStart2;
        this.yTexStart2 = yTexStart2;
        this.xTexStop2 = xTexStop2;
        this.yTexStop2 = yTexStop2;
        this.textureWidth2 = textureWidth2;
        this.textureHeight2 = textureHeight2;
        this.overlayLocation2 = overlayLocation2;
        this.overlayLocation = overlayLocation1;
        this.textureWidth = textureWidth1;
        this.textureHeight = textureHeight1;
        this.xTexStart = xTexStart1;
        this.yTexStart = yTexStart1;
        this.xTexStop = xTexStop1;
        this.yTexStop = yTexStop1;
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float partial) {
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        guiGraphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int i = this.getFGColor();
        this.renderString(guiGraphics, minecraft.font, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        if (this.overlayLocation != null) {
            guiGraphics.pose().translate(this.x1, this.y1, 0.0f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.enableDepthTest();
            guiGraphics.blit(this.overlayLocation, ScreenHelper.getWidgetX((AbstractWidget)this) + this.width / 2 - this.textureWidth / 2, ScreenHelper.getWidgetY((AbstractWidget)this) + this.height / 2 - this.textureHeight / 2, (float)this.xTexStart, (float)this.yTexStart, this.xTexStop, this.yTexStop, this.textureWidth, this.textureHeight);
            guiGraphics.pose().translate(-this.x1, -this.y1, 0.0f);
        }
        if (this.overlayLocation2 != null) {
            guiGraphics.pose().translate(this.x2, this.y2, 0.0f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.enableDepthTest();
            guiGraphics.blit(this.overlayLocation2, ScreenHelper.getWidgetX((AbstractWidget)this) + this.width / 2 - this.textureWidth2 / 2, ScreenHelper.getWidgetY((AbstractWidget)this) + this.height / 2 - this.textureHeight2 / 2, (float)this.xTexStart2, (float)this.yTexStart2, this.xTexStop2, this.yTexStop2, this.textureWidth2, this.textureHeight2);
            guiGraphics.pose().translate(-this.x2, -this.y2, 0.0f);
        }
        if (this.overlayLocation == null && this.overlayLocation2 == null) {
            this.showMessage = true;
        }
    }

    protected void renderScrollingString(GuiGraphics p_281857_, Font p_282790_, int p_282664_, int p_282944_) {
        if (this.showMessage) {
            super.renderScrollingString(p_281857_, p_282790_, p_282664_, p_282944_);
        }
    }

    private int getTextureY() {
        int i = 1;
        if (!this.active) {
            i = 0;
        } else if (this.isHoveredOrFocused()) {
            i = 2;
        }
        return 46 + i * 20;
    }

    public void hideMessage() {
        this.showMessage = false;
    }

    public void showMessage() {
        this.showMessage = true;
    }

    public void setFirstOverlay(ResourceLocation overlayLocation) {
        this.overlayLocation = overlayLocation;
    }

    public void setSecondOverlay(ResourceLocation overlayLocation) {
        this.overlayLocation2 = overlayLocation;
    }

    public void adjustFirstOverlay(float x, float y) {
        this.x1 = x;
        this.y1 = y;
    }

    public void adjustSecondOverlay(float x, float y) {
        this.x2 = x;
        this.y2 = y;
    }
}

