/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.screens.config.lists;

import com.google.common.collect.ImmutableList;
import com.stereowalker.unionlib.client.gui.components.OverflowTextButton;
import com.stereowalker.unionlib.client.gui.screens.config.lists.ListScreen;
import com.stereowalker.unionlib.config.ConfigHolder;
import com.stereowalker.unionlib.util.ScreenHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;

public class ListList<T>
extends ContainerObjectSelectionList<Entry> {
    protected ListScreen screen;
    public List<T> mainList;

    public ListList(Minecraft mcIn, ListScreen screen, ConfigHolder<List<T>> configList) {
        super(mcIn, screen.width, screen.layout.getContentHeight(), screen.layout.getHeaderHeight(), 25);
        this.screen = screen;
        this.mainList = configList.get();
        if (!configList.get().isEmpty()) {
            int index = 0;
            for (T val : configList.get()) {
                if (val instanceof String) {
                    this.addEntry((AbstractSelectionList.Entry)new StringEntry((String)val, index));
                }
                ++index;
            }
        }
        this.addEntry((AbstractSelectionList.Entry)new AddEntry());
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition();
    }

    public int getRowWidth() {
        return 230;
    }

    public void tick() {
        for (Entry ent : this.children()) {
            if (!(ent instanceof ListEntry)) continue;
            ((ListEntry)ent).tick();
        }
    }

    public class StringEntry
    extends ListEntry<String> {
        boolean setResponder;

        private StringEntry(String entry, int index) {
            super(entry, index);
            this.setResponder = false;
            this.configInteractable = new EditBox(((ListList)ListList.this).minecraft.font, 0, 0, 200, 20, (Component)Component.translatable((String)"config.editBox"));
            ((EditBox)this.configInteractable).setValue(entry);
            ListList.this.screen.addChild(this.configInteractable);
        }

        @Override
        public void tick() {
            if (!this.setResponder) {
                if (this.index < ListList.this.mainList.size()) {
                    ((EditBox)this.configInteractable).setResponder(p_214319_1_ -> this.getMainList().set(this.index, p_214319_1_));
                    this.setResponder = true;
                } else {
                    int i = 0;
                    for (Entry e : ListList.this.children()) {
                        if (e == this) {
                            this.index = i;
                            ((EditBox)this.configInteractable).setResponder(p_214319_1_ -> this.getMainList().set(this.index, p_214319_1_));
                            this.setResponder = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public class AddEntry
    extends Entry {
        protected final Button addButton = new OverflowTextButton(0, 0, 40, 20, (Component)Component.literal((String)"[+]").withStyle(ChatFormatting.GREEN), onPress -> {
            ListList.this.remove(ListList.this.mainList.size());
            if (ListList.this.mainList.size() > 0) {
                if (ListList.this.mainList.get(0) instanceof String) {
                    ListList.this.mainList.add("");
                    ListList.this.addEntry((AbstractSelectionList.Entry)new StringEntry("", ListList.this.mainList.size() - 1));
                }
            } else {
                ListList.this.mainList.add("");
                ListList.this.addEntry((AbstractSelectionList.Entry)new StringEntry("", ListList.this.mainList.size() - 1));
            }
            ListList.this.addEntry((AbstractSelectionList.Entry)new AddEntry());
        });

        private AddEntry() {
        }

        public void render(GuiGraphics p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            ScreenHelper.setWidgetPosition((AbstractWidget)this.addButton, p_230432_4_, p_230432_3_);
            this.addButton.render(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.addButton);
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.addButton);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return this.addButton.mouseClicked(mouseX, mouseY, button);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            return this.addButton.mouseReleased(mouseX, mouseY, button);
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }

    public class ListEntry<S>
    extends Entry {
        protected S entry;
        protected int index;
        protected final Button removeButton;
        protected AbstractWidget configInteractable;

        public void tick() {
        }

        protected List<S> getMainList() {
            return ListList.this.mainList;
        }

        private ListEntry(S entry, int index) {
            this.entry = entry;
            this.index = index;
            this.removeButton = new OverflowTextButton(0, 0, 20, 20, (Component)Component.literal((String)"[X]").withStyle(ChatFormatting.RED), onPress -> {
                ListList.this.remove(this.index);
                ListList.this.screen.children().remove(this.configInteractable);
                ListList.this.mainList.remove(this.index);
                int i = 0;
                for (Entry ent : ListList.this.children()) {
                    if (ent instanceof StringEntry) {
                        ((StringEntry)ent).index = i++;
                        ((StringEntry)ent).setResponder = false;
                        ((EditBox)((StringEntry)ent).configInteractable).setResponder(p_214319_1_ -> {});
                        continue;
                    }
                    if (!(ent instanceof ListEntry)) continue;
                    ((ListEntry)ent).index = i++;
                }
            });
            this.configInteractable = new OverflowTextButton(0, 0, 20, 20, (Component)Component.literal((String)"NULL").withStyle(ChatFormatting.RED), onPress -> {});
        }

        public void render(GuiGraphics p_230432_1_, int index, int top, int left, int width, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            ScreenHelper.setWidgetPosition((AbstractWidget)this.removeButton, left + 210, top);
            this.removeButton.render(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
            ScreenHelper.setWidgetPosition(this.configInteractable, left, top);
            this.configInteractable.render(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.removeButton, (Object)this.configInteractable);
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.removeButton, (Object)this.configInteractable);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.configInteractable.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            return this.removeButton.mouseClicked(mouseX, mouseY, button);
        }

        public void setFocused(boolean focused) {
            this.configInteractable.setFocused(focused);
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return this.configInteractable.isMouseOver(mouseX, mouseY) || super.isMouseOver(mouseX, mouseY);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            return this.configInteractable.mouseReleased(mouseX, mouseY, button) || this.removeButton.mouseReleased(mouseX, mouseY, button);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            return this.configInteractable.keyPressed(keyCode, scanCode, modifiers);
        }

        public boolean charTyped(char pCodePoint, int pModifiers) {
            return this.configInteractable.charTyped(pCodePoint, pModifiers);
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return this.configInteractable.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
    }
}

