/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.network.protocol.game;

import com.stereowalker.unionlib.network.protocol.game.BasePacket;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.SimpleChannel;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class ClientboundUnionPacket
extends BasePacket {
    public ClientboundUnionPacket(SimpleChannel channel) {
        super(channel);
    }

    public ClientboundUnionPacket(RegistryFriendlyByteBuf packetBuffer, SimpleChannel channel) {
        super(packetBuffer, channel);
    }

    @Override
    public void message(Supplier<CustomPayloadEvent.Context> contextSupplier) {
        MutableBoolean wasHandled = new MutableBoolean();
        if (this.shouldRun()) {
            contextSupplier.get().enqueueWork(() -> wasHandled.setValue((Boolean)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
                this.handleOnClient(Minecraft.getInstance().player);
                return this.runOnClient((Player)Minecraft.getInstance().player);
            })));
            contextSupplier.get().setPacketHandled(true);
            if (this.verifyIfHandled()) {
                System.out.println(wasHandled.booleanValue() + " Packet Handled = " + contextSupplier.get().getPacketHandled());
            }
        }
    }

    public boolean verifyIfHandled() {
        return false;
    }

    public boolean shouldRun() {
        return true;
    }

    @Deprecated
    public boolean handleOnClient(LocalPlayer player) {
        return false;
    }

    public boolean runOnClient(Player player) {
        return false;
    }

    public void send(ServerPlayer playerEntity) {
        this.channel.send((Object)this, playerEntity.connection.getConnection());
    }

    public void send(ServerLevel world) {
        for (ServerPlayer playerEntity : world.players()) {
            this.send(playerEntity);
        }
    }

    public void send(MinecraftServer server) {
        for (ServerPlayer playerEntity : server.getPlayerList().getPlayers()) {
            this.send(playerEntity);
        }
    }
}

