/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.network.protocol.game;

import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionPacket;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.world.entity.player.CustomInventoryGetter;
import com.stereowalker.unionlib.world.inventory.UnionMenu;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;

public class ServerboundUnionInventoryPacket
extends ServerboundUnionPacket {
    private UUID uuid;
    public static ResourceLocation id = VersionHelper.toLoc("unionlib:serverbound_union_inventory_packet");

    public ServerboundUnionInventoryPacket(UUID uuid) {
        super(UnionLib.instance.channel);
        this.uuid = uuid;
    }

    public ServerboundUnionInventoryPacket(RegistryFriendlyByteBuf packetBuffer) {
        super(packetBuffer, UnionLib.instance.channel);
        this.uuid = new UUID(packetBuffer.readLong(), packetBuffer.readLong());
    }

    @Override
    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeLong(this.uuid.getMostSignificantBits());
        packetBuffer.writeLong(this.uuid.getLeastSignificantBits());
    }

    @Override
    public boolean handleOnServer(ServerPlayer sender) {
        UUID uuid = this.uuid;
        if (uuid.equals(sender.getUUID())) {
            sender.openMenu((MenuProvider)new SimpleMenuProvider((p_220270_2_, p_220270_3_, p_220270_4_) -> new UnionMenu(p_220270_2_, p_220270_3_, ((CustomInventoryGetter)sender).getUnionInventory(), sender.level().isClientSide, p_220270_4_), (Component)Component.translatable((String)"")));
        }
        return true;
    }

    @Override
    public ResourceLocation id() {
        return id;
    }
}

