/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.supporter;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.stereowalker.unionlib.UnionLib;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.compress.utils.Lists;

public class Supporters {
    public static final List<Supporter> SUPPORTERS = Lists.newArrayList();
    protected static final Map<UUID, String> CAPES_LOCATION = Maps.newHashMap();
    protected static final Map<UUID, Boolean> CAPES_SHOWN = Maps.newHashMap();
    public static final String[] APPLICABLE_CAPES = new String[]{"custom1", "custom2", "custom3", "founder", "minecon2011", "minecon2012", "minecon2013", "minecon2015", "minecon2016", "pancape", "stereowalker"};

    public static void debug(Object message) {
        UnionLib.debug(message);
    }

    public static String createJson() {
        Object s = "{\r\n\t\"supporters\": [";
        for (int i = 0; i < SUPPORTERS.size(); ++i) {
            Supporter p = SUPPORTERS.get(i);
            s = (String)s + (i == 0 ? "" : ",") + "\r\n\t\t{\r\n\t\t\t\"uuid\": \"" + p.uuid.toString() + "\", \r\n\t\t\t\"name\": \"" + p.displayName + "\",\r\n\t\t\t\"type\": \"" + p.type.toString().toLowerCase() + "\", \r\n\t\t\t\"discordId\": " + p.discordId + ",\r\n\t\t\t\"showCape\": " + p.showCape + ",\r\n\t\t\t\"cape\": \"" + p.cape + "\"\r\n\t\t}";
        }
        s = (String)s + "\r\n\t]\r\n}";
        return s;
    }

    public static void cacheSupporters(URL url, File cache) throws IOException {
        BufferedReader store = new BufferedReader(new InputStreamReader(url.openStream()));
        if (!cache.exists()) {
            cache.createNewFile();
        }
        try (PrintWriter printwriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cache), StandardCharsets.UTF_8));){
            store.lines().forEach(line -> printwriter.println((String)line));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        store.close();
    }

    public static void populateSupporters(File cache, boolean createCache) {
        BufferedReader read = null;
        try {
            URL url = new URI("https://www.stereowalker.com/capes.json").toURL();
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(10000);
            connection.connect();
            Supporters.debug("Found the Supporter List File");
            read = new BufferedReader(new InputStreamReader(url.openStream()));
            if (createCache) {
                Supporters.cacheSupporters(url, cache);
            }
        }
        catch (IOException e) {
            Supporters.debug("Internet is not connected");
            if (cache.exists()) {
                try {
                    FileInputStream stream = new FileInputStream(cache);
                    InputStreamReader reader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);
                    read = new BufferedReader(reader);
                }
                catch (FileNotFoundException e1) {
                    Supporters.debug("Supproter Cache file not found");
                }
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (read != null) {
            CAPES_LOCATION.clear();
            CAPES_SHOWN.clear();
            SUPPORTERS.clear();
            JsonElement element = JsonParser.parseReader(read);
            element.getAsJsonObject().getAsJsonArray("supporters").forEach(elem -> {
                JsonObject object_2 = elem.getAsJsonObject();
                Supporter sup = new Supporter(object_2.get("name").getAsString(), object_2.get("discordId").getAsLong(), object_2.get("showCape").getAsBoolean(), UUID.fromString(object_2.get("uuid").getAsString()), Type.byName(object_2.get("type").getAsString()), object_2.get("cape").getAsString());
                sup.insertSelfToList();
                if (sup.type() != Type.DIAMOND) {
                    Supporters.debug("Found cape for " + sup.displayName() + " they seem to want to use the " + sup.cape() + " cape");
                }
            });
            ArrayList SUPPORTERS = Lists.newArrayList();
            for (Type type : Type.values()) {
                for (Supporter sup2 : Supporters.SUPPORTERS) {
                    if (!sup2.type().equals((Object)type)) continue;
                    SUPPORTERS.add(sup2);
                }
            }
            Supporters.SUPPORTERS.clear();
            Supporters.SUPPORTERS.addAll(SUPPORTERS);
            try {
                read.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Supporters.debug("No cache to load, skipping supporters. For now");
        }
    }

    public record Supporter(String displayName, long discordId, boolean showCape, UUID uuid, Type type, String cape) {
        public void insertSelfToList() {
            SUPPORTERS.add(this);
            if (this.type != Type.DIAMOND) {
                CAPES_LOCATION.put(this.uuid, this.cape);
                CAPES_SHOWN.put(this.uuid, this.showCape);
            }
        }
    }

    public static enum Type {
        OBSIDIAN(5330017, true),
        DIAMOND(1885400, true),
        PERSONAL(0xFF5555, false),
        OLDER(0x999999, false),
        SELF(0xFFAA00, false);

        public int sty;
        public boolean disp;

        private Type(int style, boolean display) {
            this.sty = style;
            this.disp = display;
        }

        public static Type byName(String pName) {
            Type[] aboat$type = Type.values();
            for (int i = 0; i < aboat$type.length; ++i) {
                if (!aboat$type[i].name().toLowerCase().equals(pName)) continue;
                return aboat$type[i];
            }
            return aboat$type[0];
        }
    }
}

