/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.util;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.level.Level;

public class VersionHelper {
    public static BlockPos posFromDouble(double x, double y, double z) {
        return BlockPos.containing((double)x, (double)y, (double)z);
    }

    public static boolean isEquippableInSlot(ArmorItem item, EquipmentSlot slot) {
        return item.getType().getSlot().equals((Object)slot);
    }

    public static Level entityLevel(Entity entity) {
        return entity.level();
    }

    public static <E extends Mob> BehaviorControl<E> createStopAttackingIfTargetInvalid(BiConsumer<E, LivingEntity> onStopAttacking) {
        return StopAttackingIfTargetInvalid.create(onStopAttacking);
    }

    public static BehaviorControl<Mob> createSetWalkTargetFromAttackTargetIfTargetOutOfReach(float speedModifier) {
        return SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)speedModifier);
    }

    public static OneShot<Mob> createMeleeAttack(int cooldownBetweenAttacks) {
        return MeleeAttack.create((int)cooldownBetweenAttacks);
    }

    public static <E extends LivingEntity> BehaviorControl<E> createEraseMemoryIf(Predicate<E> shouldEraseMemory, MemoryModuleType<?> erasingMemory) {
        return EraseMemoryIf.create(shouldEraseMemory, erasingMemory);
    }

    public static <E extends Mob> BehaviorControl<E> createStartAttacking(Function<E, Optional<? extends LivingEntity>> targetFinder) {
        return StartAttacking.create(targetFinder);
    }

    public static ResourceLocation toLoc(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    public static ResourceLocation toLoc(String location) {
        return new ResourceLocation(location);
    }
}

