/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.util.toml;

import com.stereowalker.unionlib.UnionLib;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class TomlWatcher
extends Thread {
    String madeChanges = "";
    List<String> filesToWatch = new ArrayList<String>();
    Consumer<String> onChange;
    Path directoryPath;
    WatchService watchService;

    public TomlWatcher(Path directoryPath, Consumer<String> onChange) {
        this.directoryPath = directoryPath;
        this.onChange = onChange;
        this.setName("Toml Watcher Thread");
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
            directoryPath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void start() {
        UnionLib.debug("Watching directory: " + String.valueOf(this.directoryPath), true);
        super.start();
    }

    public void watchFile(String fileToWatch) {
        UnionLib.debug("Watching file: " + fileToWatch, true);
        this.filesToWatch.add(fileToWatch);
    }

    @Override
    public void run() {
        try {
            while (true) {
                WatchKey key = this.watchService.take();
                for (WatchEvent<?> event : key.pollEvents()) {
                    if (!this.filesToWatch.contains(event.context().toString()) || event.kind() == StandardWatchEventKinds.ENTRY_CREATE || event.kind() == StandardWatchEventKinds.ENTRY_DELETE || event.kind() != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                    UnionLib.debug("File modified: " + String.valueOf(event.context()));
                    this.onChange.accept(event.context().toString());
                }
                key.reset();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }
}

