/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.world.inventory;

import com.mojang.datafixers.util.Pair;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import com.stereowalker.unionlib.world.entity.player.UnionInventory;
import com.stereowalker.unionlib.world.inventory.UMenuType;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class UnionMenu
extends RecipeBookMenu<CraftingContainer> {
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS, InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS, InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE, InventoryMenu.EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private static final ResourceLocation[] ACCESSORY_SLOT_TEXTURES = new ResourceLocation[]{UnionLib.Locations.EMPTY_ACCESSORY_SLOT_NECKLACE, UnionLib.Locations.EMPTY_ACCESSORY_SLOT_BACK, UnionLib.Locations.EMPTY_ACCESSORY_SLOT_RING};
    private static final AccessorySlot[] VALID_ACCESSORY_SLOTS = new AccessorySlot[]{AccessorySlot.NECK_1, AccessorySlot.BACK_1, AccessorySlot.BACK_2, AccessorySlot.FINGER_1, AccessorySlot.BACK_3, AccessorySlot.BACK_4, AccessorySlot.FINGER_2, AccessorySlot.BACK_5, AccessorySlot.BACK_6};
    private final CraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 2, 2);
    private final ResultContainer craftResult = new ResultContainer();
    private final UnionInventory inventory;
    public final boolean isLocalWorld;
    private final Player owner;

    public UnionMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, new UnionInventory(playerInventory.player), false, playerInventory.player);
    }

    public UnionMenu(int id, Inventory playerInventory, UnionInventory unionInventory, boolean localWorld, Player playerIn) {
        super(UMenuType.UNION, id);
        int l;
        this.isLocalWorld = localWorld;
        this.owner = playerIn;
        this.inventory = unionInventory;
        this.addSlot((Slot)new ResultSlot(playerInventory.player, this.craftMatrix, (Container)this.craftResult, 0, 143, 62));
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.addSlot(new Slot((Container)this.craftMatrix, j + i * 2, 134 + j * 18, 8 + i * 18));
            }
        }
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlot equipmentslottype = VALID_EQUIPMENT_SLOTS[k];
            this.addSlot(new Slot((Container)playerInventory, 39 - k, 8, 8 + k * 18){

                public int getMaxStackSize() {
                    return 1;
                }

                public boolean mayPlace(ItemStack stack) {
                    return stack.canEquip(equipmentslottype, (Entity)UnionMenu.this.owner);
                }

                public boolean mayPickup(Player playerIn) {
                    ItemStack itemstack = this.getItem();
                    return !itemstack.isEmpty() && !playerIn.isCreative() && EnchantmentHelper.hasBindingCurse((ItemStack)itemstack) ? false : super.mayPickup(playerIn);
                }

                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)ARMOR_SLOT_TEXTURES[equipmentslottype.getIndex()]);
                }
            });
        }
        for (l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)playerInventory, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)playerInventory, i1, 8 + i1 * 18, 142));
        }
        this.addSlot(new Slot(this, (Container)playerInventory, 40, 77, 62){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        for (l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 3; ++j1) {
                int index = j1 + l * 3;
                final AccessorySlot accessoryslottype = VALID_ACCESSORY_SLOTS[index];
                this.addSlot(new Slot(this, (Container)this.inventory, index, 77 + j1 * 18, 8 + l * 18){

                    public int getMaxStackSize() {
                        return 1;
                    }

                    public boolean mayPlace(ItemStack stack) {
                        return accessoryslottype.getValidStack().test(stack);
                    }

                    public boolean mayPickup(Player playerIn) {
                        ItemStack itemstack = this.getItem();
                        return !itemstack.isEmpty() && !playerIn.isCreative() && EnchantmentHelper.hasBindingCurse((ItemStack)itemstack) ? false : super.mayPickup(playerIn);
                    }

                    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)ACCESSORY_SLOT_TEXTURES[accessoryslottype.getTextureIndex()]);
                    }
                });
            }
        }
    }

    public void fillCraftSlotsStackedContents(StackedContents itemHelperIn) {
        this.craftMatrix.fillStackedContents(itemHelperIn);
    }

    public void clearCraftingContent() {
        this.craftResult.clearContent();
        this.craftMatrix.clearContent();
    }

    public boolean recipeMatches(RecipeHolder<? extends Recipe<CraftingContainer>> pRecipe) {
        return pRecipe.value().matches((Container)this.craftMatrix, this.owner.level());
    }

    public void slotsChanged(Container inventoryIn) {
        UnionMenu.updateCraftingResult(this, this.owner.level(), this.owner, this.craftMatrix, this.craftResult);
    }

    protected static void updateCraftingResult(UnionMenu container, Level pLevel, Player player, CraftingContainer pContainer, ResultContainer inventoryResult) {
        if (!pLevel.isClientSide) {
            ServerPlayer serverplayerentity = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.EMPTY;
            Optional optional = pLevel.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)pContainer, pLevel);
            if (optional.isPresent()) {
                RecipeHolder recipeholder = (RecipeHolder)optional.get();
                CraftingRecipe craftingrecipe = (CraftingRecipe)recipeholder.value();
                if (inventoryResult.setRecipeUsed(pLevel, serverplayerentity, recipeholder)) {
                    itemstack = craftingrecipe.assemble((Container)pContainer, (HolderLookup.Provider)pLevel.registryAccess());
                }
            }
            inventoryResult.setItem(0, itemstack);
            serverplayerentity.connection.send((Packet)new ClientboundContainerSetSlotPacket(container.containerId, container.incrementStateId(), 0, itemstack));
        }
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.craftResult.clearContent();
        if (!playerIn.level().isClientSide) {
            this.clearContainer(playerIn, (Container)this.craftMatrix);
        }
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            int i;
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            EquipmentSlot equipmentslottype = Mob.getEquipmentSlotForItem((ItemStack)itemstack);
            if (index == 0) {
                if (!this.moveItemStackTo(itemstack1, 9, 45, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index >= 1 && index < 5 ? !this.moveItemStackTo(itemstack1, 9, 45, false) : (index >= 5 && index < 9 ? !this.moveItemStackTo(itemstack1, 9, 45, false) : (equipmentslottype.getType() == EquipmentSlot.Type.ARMOR && !((Slot)this.slots.get(8 - equipmentslottype.getIndex())).hasItem() ? !this.moveItemStackTo(itemstack1, i = 8 - equipmentslottype.getIndex(), i + 1, false) : (equipmentslottype == EquipmentSlot.OFFHAND && !((Slot)this.slots.get(45)).hasItem() ? !this.moveItemStackTo(itemstack1, 45, 46, false) : (index >= 9 && index < 36 ? !this.moveItemStackTo(itemstack1, 36, 45, false) : (index >= 36 && index < 45 ? !this.moveItemStackTo(itemstack1, 9, 36, false) : !this.moveItemStackTo(itemstack1, 9, 45, false))))))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
            if (index == 0) {
                playerIn.drop(itemstack1, false);
            }
        }
        return itemstack;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn.container != this.craftResult && super.canTakeItemForPickAll(stack, slotIn);
    }

    public int getResultSlotIndex() {
        return 0;
    }

    public int getGridWidth() {
        return this.craftMatrix.getWidth();
    }

    public int getGridHeight() {
        return this.craftMatrix.getHeight();
    }

    public int getSize() {
        return 5;
    }

    public CraftingContainer getCraftSlots() {
        return this.craftMatrix;
    }

    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    public boolean shouldMoveToInventory(int p_150591_) {
        return p_150591_ != this.getResultSlotIndex();
    }
}

