/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stereowalker.unionlib.world.item.crafting.URecipeSerializer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class NoRemainderShaplessRecipe
extends ShapelessRecipe {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;

    public NoRemainderShaplessRecipe(String pGroup, CraftingBookCategory pCategory, ItemStack pResult, NonNullList<Ingredient> pIngredients) {
        super(pGroup, pCategory, pResult, pIngredients);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.withSize((int)inv.getContainerSize(), (Object)ItemStack.EMPTY);
        return nonnulllist;
    }

    public RecipeSerializer<?> getSerializer() {
        return URecipeSerializer.NO_REMAINDER_SHAPELESS_RECIPE;
    }

    public static class Serializer
    implements RecipeSerializer<NoRemainderShaplessRecipe> {
        private static final MapCodec<NoRemainderShaplessRecipe> CODEC = RecordCodecBuilder.mapCodec(p_327212_ -> p_327212_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_299460_ -> p_299460_.getGroup()), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_297437_ -> p_297437_.category()), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_300770_ -> p_300770_.getResultItem(null)), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(p_297969_ -> {
            Object[] aingredient = (Ingredient[])p_297969_.stream().filter(p_298915_ -> !p_298915_.isEmpty()).toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(p_298509_ -> p_298509_.getIngredients())).apply((Applicative)p_327212_, NoRemainderShaplessRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, NoRemainderShaplessRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<NoRemainderShaplessRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, NoRemainderShaplessRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static NoRemainderShaplessRecipe fromNetwork(RegistryFriendlyByteBuf p_335962_) {
            String s = p_335962_.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)p_335962_.readEnum(CraftingBookCategory.class);
            int i = p_335962_.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonnulllist.replaceAll(p_327214_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)p_335962_));
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)p_335962_);
            return new NoRemainderShaplessRecipe(s, craftingbookcategory, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        private static void toNetwork(RegistryFriendlyByteBuf p_329239_, NoRemainderShaplessRecipe p_44282_) {
            p_329239_.writeUtf(p_44282_.getGroup());
            p_329239_.writeEnum((Enum)p_44282_.category());
            p_329239_.writeVarInt(p_44282_.getIngredients().size());
            for (Ingredient ingredient : p_44282_.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)p_329239_, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)p_329239_, (Object)p_44282_.getResultItem(null));
        }
    }
}

