/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib;

import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.api.collectors.InsertCollector;
import com.stereowalker.unionlib.api.collectors.MenuCollector;
import com.stereowalker.unionlib.api.keymaps.KeyMappingCollector;
import com.stereowalker.unionlib.client.gui.screens.config.ConfigScreen;
import com.stereowalker.unionlib.client.gui.screens.inventory.UnionInventoryScreen;
import com.stereowalker.unionlib.client.keybindings.KeyBindings;
import com.stereowalker.unionlib.client.model.HatModel;
import com.stereowalker.unionlib.insert.ClientInserts;
import com.stereowalker.unionlib.mod.ClientSegment;
import com.stereowalker.unionlib.mod.ModHandler;
import com.stereowalker.unionlib.supporter.CosmeticHandler;
import com.stereowalker.unionlib.supporter.CosmeticSelection;
import com.stereowalker.unionlib.supporter.Cosmetics;
import com.stereowalker.unionlib.world.inventory.UMenuType;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class UnionLibClientSegment
extends ClientSegment {
    private Map<LivingEntityRenderer<?, ?>, HatModel<?>> cosmetics = new WeakHashMap();

    @Override
    public void initClientAfterMinecraft(Minecraft mc) {
        new Cosmetics(mc);
    }

    @Override
    public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
        return new ConfigScreen(previousScreen, UnionLib.CONFIG, (Component)Component.translatable((String)"UnionLib Config"));
    }

    @Override
    public void setupKeymappings(KeyMappingCollector collector) {
        collector.addKeyMapping(KeyBindings.OPEN_UNION_INVENTORY);
    }

    @Override
    public void registerInserts(InsertCollector collector) {
        collector.addInsert(ClientInserts.CLIENT_TICK_BEGIN, ins -> {
            if (Minecraft.getInstance().level != null && Minecraft.getInstance().level.players().size() > 1 && Cosmetics.shouldWePoll()) {
                Cosmetics.pollCosmetics();
            }
        });
        collector.addInsert(ClientInserts.ITEM_TOOLTIP, ins -> {
            if (ins.flags().isAdvanced() && UnionLib.CONFIG.tags) {
                ArrayList tags = new ArrayList();
                ins.itemStack().getTags().forEach(tag -> tags.add(Component.literal((String)("#" + String.valueOf(tag.location()))).withColor(UnionLib.CONFIG.tagColor)));
                if (ins.itemStack().getComponents().size() > 0) {
                    ins.tooltips().addAll(ins.tooltips().size() - 1, tags);
                } else {
                    ins.tooltips().addAll(tags);
                }
            }
        });
        collector.addInsert(ClientInserts.LIVING_RENDER_FINISH, ins -> {
            AbstractClientPlayer player;
            LivingEntity patt0$temp = ins.entity();
            if (patt0$temp instanceof AbstractClientPlayer && CosmeticHandler.doesPlayerNeedCosmetic((Player)(player = (AbstractClientPlayer)patt0$temp))) {
                LivingEntityRenderer ler = ins.renderer();
                CosmeticSelection hat = CosmeticHandler.getHat((Player)player);
                if (!this.cosmetics.containsKey(ins.renderer()) || !hat.equals(this.cosmetics.get(ins.renderer()).getHat())) {
                    this.cosmetics.put(ins.renderer(), new HatModel(hat));
                }
                HatModel<?> hatmodel = this.cosmetics.get(ins.renderer());
                boolean hasTexture = false;
                if (hatmodel.getHat().variant().equals("custom")) {
                    hasTexture = hatmodel.getCosmetic().texture(hatmodel.getHat().variant() + "_" + hatmodel.getCosmetic().segments().get(0)) != null;
                } else {
                    boolean bl = hasTexture = hatmodel.getCosmetic().texture(hatmodel.getHat().variant()) != null;
                }
                if (hasTexture && (hatmodel.getCosmetic().showOnHelmet() || player.getItemBySlot(EquipmentSlot.HEAD).isEmpty())) {
                    ins.poseStack().pushPose();
                    CosmeticHandler.setupPose(ler, player, ins.entityYaw(), ins.partialTick(), ins.poseStack(), ins.multiBufferSource(), ins.packedLight());
                    CosmeticHandler.addCosmetic(ler, player, ins.poseStack(), ins.multiBufferSource(), hatmodel, ins.packedLight(), ins.partialTick(), (HumanoidModel)ler.getModel());
                    ins.poseStack().popPose();
                }
            }
        });
    }

    @Override
    public ResourceLocation getModIcon() {
        return UnionLib.Locations.UNION_BUTTON_IMAGE;
    }

    @Override
    public void setupMenus(MenuCollector collector) {
        if (!ModHandler.getLoadState().runsOnlyOnClient()) {
            collector.addMenu(UMenuType.UNION, UnionInventoryScreen::new);
        }
    }
}

