/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.stereowalker.unionlib.config.ConfigBuilder;
import com.stereowalker.unionlib.config.ConfigObject;
import com.stereowalker.unionlib.config.ConfigSide;
import com.stereowalker.unionlib.config.UnionConfig;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.util.LoaderHelper;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ConfigObjectBuilder {
    static final Map<ConfigObject, List<String>> configs = Maps.newHashMap();
    public static final Map<ConfigObject, Boolean> config_initialization = Maps.newHashMap();

    public static MutableComponent getConfigName(ConfigObject configObject) {
        if (configObject.getClass().isAnnotationPresent(UnionConfig.class)) {
            UnionConfig config = configObject.getClass().getAnnotation(UnionConfig.class);
            if (config.translatableName().isEmpty()) {
                return Component.translatable((String)config.name());
            }
            return Component.translatable((String)config.translatableName());
        }
        return Component.translatable((String)"");
    }

    public static void reloadAll(Map<String, String> values) {
        configs.keySet().forEach(obj -> ConfigBuilder.read(obj.getClass(), obj, values, ConfigSide.Shared));
    }

    public static boolean hasConfigType(ConfigObject configObject, ConfigSide side) {
        if (configObject.getClass().isAnnotationPresent(UnionConfig.class)) {
            for (Field field : configObject.getClass().getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null || configEntry.side() != side) continue;
                return true;
            }
        }
        return false;
    }

    public static void registerConfigurations(MinecraftMod mod, ConfigObject configObject) {
        UnionConfig con = configObject.getClass().getAnnotation(UnionConfig.class);
        String name = con.folder().isEmpty() ? con.name() : con.folder() + File.separator + con.name();
        ConfigBuilder.Init client = new ConfigBuilder.Init(name, con, "client");
        ConfigBuilder.Init common = new ConfigBuilder.Init(name, con, "common");
        ConfigBuilder.Init server = new ConfigBuilder.Init(name, con, "server");
        ConfigBuilder.init(configObject.getClass(), configObject, server, common, client, () -> config_initialization.put(configObject, true));
        ArrayList aliases = Lists.newArrayList();
        if (ConfigObjectBuilder.hasConfigType(configObject, ConfigSide.Client)) {
            aliases.add(client.filename);
            if (!client.writer.fileExists()) {
                client.writer.buildToFile();
            }
        }
        if (ConfigObjectBuilder.hasConfigType(configObject, ConfigSide.Shared)) {
            aliases.add(common.filename);
            if (!common.writer.fileExists()) {
                common.writer.buildToFile();
            }
        }
        if (ConfigObjectBuilder.hasConfigType(configObject, ConfigSide.Server)) {
            aliases.add(server.filename);
            if (!server.writer.fileExists()) {
                server.writer.buildToFile();
            }
        }
        configs.put(configObject, aliases);
    }

    public static void loadConfigs(ConfigObject configObject) {
        UnionConfig con = configObject.getClass().getAnnotation(UnionConfig.class);
        if (ConfigObjectBuilder.hasConfigType(configObject, ConfigSide.Client)) {
            ConfigBuilder.loadConfig(LoaderHelper.configPath().toString() + (String)(con.folder().isEmpty() ? "" : File.separator + con.folder()), con.name() + (con.appendWithType() ? "-client" : "") + ".toml");
        }
        if (ConfigObjectBuilder.hasConfigType(configObject, ConfigSide.Shared)) {
            ConfigBuilder.loadConfig(LoaderHelper.configPath().toString() + (String)(con.folder().isEmpty() ? "" : File.separator + con.folder()), con.name() + (con.appendWithType() ? "-common" : "") + ".toml");
        }
        if (ConfigObjectBuilder.hasConfigType(configObject, ConfigSide.Server)) {
            ConfigBuilder.loadConfig(LoaderHelper.configPath().toString() + (String)(con.folder().isEmpty() ? "" : File.separator + con.folder()), con.name() + (con.appendWithType() ? "-server" : "") + ".toml");
        }
    }
}

