/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.neoforge;

import com.stereowalker.unionlib.api.creativetabs.CreativeTabBuilder;
import com.stereowalker.unionlib.api.registries.RegistryCollector;
import com.stereowalker.unionlib.api.registries.RegistryWrapper;
import com.stereowalker.unionlib.core.registries.Housing;
import com.stereowalker.unionlib.core.registries.RegistryObject;
import com.stereowalker.unionlib.insert.ClientInserts;
import com.stereowalker.unionlib.insert.Inserts;
import com.stereowalker.unionlib.insert.ServerInserts;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.ModHandler;
import com.stereowalker.unionlib.world.entity.ai.UAttributes;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.player.CanContinueSleepingEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.apache.logging.log4j.Logger;

public class PlatformHelper {
    @Deprecated
    public static boolean isClientInstance() {
        return FMLEnvironment.dist.isClient();
    }

    @Deprecated
    public static boolean isServerInstance() {
        return FMLEnvironment.dist.isDedicatedServer();
    }

    @Deprecated
    public static boolean isDevEnvironment() {
        return !FMLEnvironment.production;
    }

    public static void handleEvents() {
        IEventBus neoBus = NeoForge.EVENT_BUS;
        neoBus.addListener(ModHandler::registerAllServerRelaodableResources);
        neoBus.addListener(event -> {
            if (ModHandler.getLoadState().runsOnServer()) {
                boolean weCrit = false;
                double critRate = event.getEntity().getAttributeValue(UAttributes.CRITICAL_RATE.holder());
                if (critRate > 0.0 && !event.isVanillaCritical()) {
                    Random random = new Random();
                    if (random.nextDouble() < critRate) {
                        weCrit = true;
                        event.setCriticalHit(true);
                    }
                }
                if (event.isVanillaCritical() || weCrit) {
                    event.setDamageMultiplier((float)event.getEntity().getAttributeValue(UAttributes.CRITICAL_DAMAGE.holder()));
                }
            }
        });
        neoBus.addListener(evt -> Inserts.PLAYER_ATTACK.insert(evt.getEntity(), evt.getTarget(), c -> {
            if (c.booleanValue()) {
                evt.setCanceled(true);
            }
        }));
        neoBus.addListener(evt -> Inserts.LIVING_FALL.insert(evt.getEntity(), evt.getDistance(), arg_0 -> ((LivingFallEvent)evt).setDistance(arg_0), evt.getDamageMultiplier(), arg_0 -> ((LivingFallEvent)evt).setDamageMultiplier(arg_0), () -> evt.setCanceled(true)));
        neoBus.addListener(evt -> Inserts.FOV.insert(evt.getPlayer(), evt.getFovModifier(), evt.getNewFovModifier(), arg_0 -> ((ComputeFovModifierEvent)evt).setNewFovModifier(arg_0)));
        neoBus.addListener(event -> Inserts.LIVING_ATTACK.insert(event.getEntity(), event.getSource(), event.getAmount()));
        neoBus.addListener(event -> Inserts.LIVING_DEATH.insert(event.getEntity(), event.getSource()));
        neoBus.addListener(event -> Inserts.LIVING_HEAL.insert(event.getEntity(), event.getAmount(), arg_0 -> ((LivingHealEvent)event).setAmount(arg_0)));
        neoBus.addListener(event -> Inserts.ENTITY_JOIN_LEVEL.insert(event.getEntity(), event.getLevel(), event.loadedFromDisk()));
        neoBus.addListener(event -> Inserts.FINISH_SLEEP.insert(event.getLevel(), event.getNewTime(), arg_0 -> ((SleepFinishedTimeEvent)event).setTimeAddition(arg_0)));
        neoBus.addListener(evt -> Inserts.LOOT_TABLE_LOAD.insert(evt.getName(), evt.getTable(), arg_0 -> ((LootTableLoadEvent)evt).setTable(arg_0), () -> evt.setCanceled(true)));
        neoBus.addListener(event -> Inserts.LEVEL_SAVE.insert(event.getLevel()));
        neoBus.addListener(event -> Inserts.LEVEL_LOAD.insert(event.getLevel()));
        neoBus.addListener(event -> Inserts.LIVING_JUMP.insert(event.getEntity()));
        neoBus.addListener(event -> {
            Entity patt0$temp = event.getEntity();
            if (patt0$temp instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt0$temp;
                Inserts.LIVING_TICK.insert(living);
            }
        });
        neoBus.addListener(evt -> Inserts.ENTITY_TICK_BEGIN.insert(evt.getEntity(), c -> {
            if (c.booleanValue()) {
                evt.setCanceled(true);
            }
        }));
        neoBus.addListener(evt -> Inserts.ENTITY_TICK_FINISH.insert(evt.getEntity()));
        neoBus.addListener(event -> Inserts.ITEM_USE_FINISH.insert(event.getEntity(), event.getItem(), event.getDuration(), event.getResultStack(), arg_0 -> ((LivingEntityUseItemEvent.Finish)event).setResultStack(arg_0)));
        neoBus.addListener(event -> Inserts.MENU_CLOSE.insert(event.getEntity(), event.getContainer()));
        neoBus.addListener(event -> Inserts.MENU_OPEN.insert(event.getEntity(), event.getContainer()));
        neoBus.addListener(evt -> Inserts.INTERACT_WITH_ENTITY.insert(evt.getEntity(), evt.getHand(), evt.getTarget(), c -> {
            if (c.booleanValue()) {
                evt.setCanceled(true);
            }
        }, evt.getCancellationResult(), arg_0 -> ((PlayerInteractEvent.EntityInteract)evt).setCancellationResult(arg_0)));
        neoBus.addListener(evt -> Inserts.INTERACT_WITH_BLOCK.insert(evt.getEntity(), evt.getLevel(), evt.getHand(), evt.getHitVec(), evt.getCancellationResult(), arg_0 -> ((PlayerInteractEvent.RightClickBlock)evt).setCancellationResult(arg_0), () -> evt.setCanceled(true)));
        neoBus.addListener(evt -> Inserts.INTERACT_WITH_ITEM.insert(evt.getEntity(), evt.getLevel(), evt.getHand(), (InteractionResultHolder<ItemStack>)new InteractionResultHolder(evt.getCancellationResult(), (Object)evt.getItemStack()), cancel -> evt.setCancellationResult(cancel.getResult()), () -> evt.setCanceled(true)));
        neoBus.addListener(event -> Inserts.PLAYER_RESTORE.insert(event.getEntity(), event.getOriginal(), !event.isWasDeath()));
        neoBus.addListener(event -> Inserts.LOGGED_OUT.insert(event.getEntity()));
        neoBus.addListener(event -> Inserts.LOGGED_IN.insert(event.getEntity()));
        neoBus.addListener(event -> Inserts.XP_PICKUP.insert(event.getEntity(), event.getOrb()));
        neoBus.addListener(event -> ServerInserts.VILLAGER_TRADES.insert(event.getType(), (Int2ObjectMap<List<VillagerTrades.ItemListing>>)event.getTrades(), false));
        neoBus.addListener(event -> ServerInserts.SERVER_STARTING.insert(event.getServer()));
        neoBus.addListener(event -> ServerInserts.SERVER_STARTED.insert(event.getServer()));
        neoBus.addListener(event -> ServerInserts.SERVER_STOPPING.insert(event.getServer()));
        neoBus.addListener(event -> ServerInserts.SERVER_STOPPED.insert(event.getServer()));
        neoBus.addListener(event -> Inserts.PLAYER_CAN_SLEEP.insert((Player)event.getEntity(), event.getPos(), event.getProblem(), event.getVanillaProblem(), arg_0 -> ((CanPlayerSleepEvent)event).setProblem(arg_0)));
        neoBus.addListener(event -> {
            LivingEntity patt0$temp = event.getEntity();
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                Inserts.PLAYER_CONTINUE_SLEEP.insert(player, (BlockPos)player.getSleepingPos().get(), event.mayContinueSleeping(), arg_0 -> ((CanContinueSleepingEvent)event).setContinueSleeping(arg_0));
            }
        });
        neoBus.addListener(event -> Inserts.LEVEL_WAKE_UP.insert(event.getLevel(), event.getNewTime(), arg_0 -> ((SleepFinishedTimeEvent)event).setTimeAddition(arg_0)));
    }

    public static void handleClientEvents() {
        IEventBus neoBus = NeoForge.EVENT_BUS;
        neoBus.addListener(evt -> ClientInserts.CLIENT_TICK_BEGIN.insert());
        neoBus.addListener(evt -> ClientInserts.CLIENT_TICK_FINISH.insert());
        neoBus.addListener(event -> ClientInserts.ITEM_TOOLTIP.insert(event.getItemStack(), event.getEntity(), event.getToolTip(), event.getFlags()));
        neoBus.addListener(evt -> ClientInserts.SCREEN_RENDER_FINISH.insert(evt.getScreen(), evt.getGuiGraphics(), evt.getMouseX(), evt.getMouseY(), evt.getPartialTick()));
    }

    public static <T> void handleRegistration(MinecraftMod mod, String namespace, Field[] fields, ResourceKey<Registry<T>> registryKey, Logger LOGGER) {
        DeferredRegister ARMOR_MATERIAL = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)namespace);
        DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)namespace);
        DeferredRegister.DataComponents COMPONENTS = DeferredRegister.createDataComponents((String)namespace);
        DeferredRegister FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)namespace);
        DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)namespace);
        DeferredRegister POTIONS = DeferredRegister.create((ResourceKey)Registries.POTION, (String)namespace);
        DeferredRegister MOB_EFFECTS = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)namespace);
        DeferredRegister ATTRIBUTES = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)namespace);
        DeferredRegister SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)namespace);
        DeferredRegister SENSOR_TYPE = DeferredRegister.create((ResourceKey)Registries.SENSOR_TYPE, (String)namespace);
        DeferredRegister MENU_TYPE = DeferredRegister.create((ResourceKey)Registries.MENU, (String)namespace);
        DeferredRegister ENCHANTMENT_COMPONENTS = DeferredRegister.create((ResourceKey)Registries.ENCHANTMENT_EFFECT_COMPONENT_TYPE, (String)namespace);
        DeferredRegister PARTICLE_TYPES = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)namespace);
        for (Field field : fields) {
            DeferredHolder val;
            Housing hou;
            if (!field.isAnnotationPresent(RegistryObject.class)) continue;
            RegistryObject regi = field.getAnnotation(RegistryObject.class);
            String regName = regi.value();
            Consumer<Exception> exc = e -> {
                e.printStackTrace();
                LOGGER.warn("There was an error registering " + regName);
            };
            if (registryKey.equals((Object)Registries.BLOCK)) {
                BLOCKS.register(regName, () -> {
                    try {
                        return (Block)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (registryKey.equals((Object)Registries.FLUID)) {
                FLUIDS.register(regName, () -> {
                    try {
                        return (Fluid)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (registryKey.equals((Object)Registries.ITEM)) {
                ITEMS.register(regName, () -> {
                    try {
                        return (Item)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (registryKey.equals((Object)Registries.ARMOR_MATERIAL)) {
                try {
                    if (!(field.get(null) instanceof Housing)) {
                        throw new UnsupportedOperationException("Please wrap \"" + regName + " in a housing\".");
                    }
                    hou = (Housing)field.get(null);
                    val = ARMOR_MATERIAL.register(regName, hou.value());
                    hou.setHolder(() -> Optional.of(val));
                }
                catch (IllegalAccessException | IllegalArgumentException e2) {
                    exc.accept(e2);
                }
                continue;
            }
            if (registryKey.equals((Object)Registries.ATTRIBUTE)) {
                try {
                    if (field.get(null) instanceof Housing) {
                        hou = (Housing)field.get(null);
                        val = ATTRIBUTES.register(regName, hou.value());
                        hou.setHolder(() -> Optional.of(val));
                        continue;
                    }
                    ATTRIBUTES.register(regName, () -> {
                        try {
                            return (Attribute)field.get(null);
                        }
                        catch (IllegalAccessException | IllegalArgumentException e) {
                            exc.accept(e);
                            return null;
                        }
                    });
                }
                catch (IllegalAccessException | IllegalArgumentException e3) {
                    exc.accept(e3);
                }
                continue;
            }
            if (registryKey.equals((Object)Registries.MOB_EFFECT)) {
                try {
                    if (!(field.get(null) instanceof Housing)) {
                        throw new UnsupportedOperationException("Please wrap \"" + regName + " in a housing\".");
                    }
                    hou = (Housing)field.get(null);
                    val = MOB_EFFECTS.register(regName, hou.value());
                    hou.setHolder(() -> Optional.of(val));
                }
                catch (IllegalAccessException | IllegalArgumentException e4) {
                    exc.accept(e4);
                }
                continue;
            }
            if (registryKey.equals((Object)Registries.POTION)) {
                try {
                    if (!(field.get(null) instanceof Housing)) {
                        throw new UnsupportedOperationException("Please wrap \"" + regName + " in a housing\".");
                    }
                    hou = (Housing)field.get(null);
                    val = POTIONS.register(regName, hou.value());
                    hou.setHolder(() -> Optional.of(val));
                }
                catch (IllegalAccessException | IllegalArgumentException e5) {
                    exc.accept(e5);
                }
                continue;
            }
            if (registryKey.equals((Object)Registries.RECIPE_SERIALIZER)) {
                SERIALIZERS.register(regName, () -> {
                    try {
                        return (RecipeSerializer)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (registryKey.equals((Object)Registries.DATA_COMPONENT_TYPE)) {
                COMPONENTS.register(regName, () -> {
                    try {
                        return (DataComponentType)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (registryKey.equals((Object)Registries.SENSOR_TYPE)) {
                SENSOR_TYPE.register(regName, () -> {
                    try {
                        return (SensorType)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (registryKey.equals((Object)Registries.MENU)) {
                MENU_TYPE.register(regName, () -> {
                    try {
                        return (MenuType)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (registryKey.equals((Object)Registries.ENCHANTMENT_EFFECT_COMPONENT_TYPE)) {
                ENCHANTMENT_COMPONENTS.register(regName, () -> {
                    try {
                        return (DataComponentType)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (registryKey.equals((Object)Registries.PARTICLE_TYPE)) {
                PARTICLE_TYPES.register(regName, () -> {
                    try {
                        return (ParticleType)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            throw new UnsupportedOperationException("Cannot register \"" + String.valueOf(registryKey) + "'s\" through Needle.");
        }
        IEventBus modEventBus = ModHandler.mods.get(mod.getModid()).eventBus();
        BLOCKS.register(modEventBus);
        FLUIDS.register(modEventBus);
        ITEMS.register(modEventBus);
        POTIONS.register(modEventBus);
        ARMOR_MATERIAL.register(modEventBus);
        MOB_EFFECTS.register(modEventBus);
        SERIALIZERS.register(modEventBus);
        ATTRIBUTES.register(modEventBus);
        MENU_TYPE.register(modEventBus);
        COMPONENTS.register(modEventBus);
        ENCHANTMENT_COMPONENTS.register(modEventBus);
        PARTICLE_TYPES.register(modEventBus);
    }

    public static void doCreativeTabs(MinecraftMod mod) {
        IEventBus modEventBus = ModHandler.mods.get(mod.getModid()).eventBus();
        DeferredRegister CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)mod.getModid());
        CreativeTabBuilder builders = (name, tab) -> {
            if (tab != null) {
                CREATIVE_MODE_TABS.register(name, () -> tab);
            }
        };
        mod.registerCreativeTabs(builders);
        CREATIVE_MODE_TABS.register(modEventBus);
    }

    public static <V> RegistryWrapper<V> createWrappedRegistry(MinecraftMod mod, boolean shouldSync, ResourceKey<Registry<V>> registryKey) {
        final Registry registry = new RegistryBuilder(registryKey).sync(true).maxId(0x7FFFFFFE).sync(shouldSync).create();
        mod.eventBus().addListener(event -> event.register(registry));
        return new RegistryWrapper<V>(){

            @Override
            public Iterator<V> iterator() {
                return registry.iterator();
            }

            @Override
            public V get(ResourceLocation key) {
                return registry.get(key);
            }

            @Override
            public ResourceLocation key(V val) {
                return registry.getKey(val);
            }
        };
    }

    public static <T> void registerCustom(MinecraftMod mod, ResourceKey<Registry<T>> registry, Consumer<RegistryCollector.Custom<T>> register) {
        mod.eventBus().addListener(event -> event.register(registry, helper -> register.accept(new RegistryCollector.Custom<T>((RegisterEvent.RegisterHelper)helper){
            final /* synthetic */ RegisterEvent.RegisterHelper val$helper;
            {
                this.val$helper = registerHelper;
            }

            @Override
            public void register(ResourceLocation name, T value) {
                this.val$helper.register(name, value);
            }
        })));
    }
}

