/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.network.protocol.game;

import com.stereowalker.unionlib.config.ConfigClassBuilder;
import com.stereowalker.unionlib.config.ConfigObjectBuilder;
import com.stereowalker.unionlib.network.protocol.game.ClientboundUnionPacket;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ClientboundConfigPacket
extends ClientboundUnionPacket {
    private Map<String, String> kv = new HashMap<String, String>();
    public static ResourceLocation id = VersionHelper.toLoc("unionlib:clientbounf_config_packet");

    public ClientboundConfigPacket(Map<String, String> kv) {
        super(null);
        kv.forEach(this.kv::put);
    }

    public ClientboundConfigPacket(RegistryFriendlyByteBuf packetBuffer) {
        super(packetBuffer);
        int size = packetBuffer.readVarInt();
        for (int i = 0; i < size; ++i) {
            this.kv.put(packetBuffer.readUtf(), packetBuffer.readUtf());
        }
    }

    @Override
    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeVarInt(this.kv.size());
        this.kv.forEach((k, v) -> {
            packetBuffer.writeUtf(k);
            packetBuffer.writeUtf(v);
        });
    }

    @Override
    public boolean runOnClient(Player player) {
        ConfigClassBuilder.reloadAll(this.kv);
        ConfigObjectBuilder.reloadAll(this.kv);
        return true;
    }

    @Override
    public ResourceLocation id() {
        return id;
    }
}

