/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stereowalker.unionlib.util.math.Color;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.model.Model;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;

public class VersionHelper {
    public static BlockPos posFromDouble(double x, double y, double z) {
        return BlockPos.containing((double)x, (double)y, (double)z);
    }

    public static boolean isEquippableInSlot(ArmorItem item, EquipmentSlot slot) {
        return item.getType().getSlot().equals((Object)slot);
    }

    public static Level entityLevel(Entity entity) {
        return entity.level();
    }

    public static <E extends Mob> BehaviorControl<E> createStopAttackingIfTargetInvalid(BiConsumer<E, LivingEntity> onStopAttacking) {
        return StopAttackingIfTargetInvalid.create(onStopAttacking);
    }

    public static BehaviorControl<Mob> createSetWalkTargetFromAttackTargetIfTargetOutOfReach(float speedModifier) {
        return SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)speedModifier);
    }

    public static OneShot<Mob> createMeleeAttack(int cooldownBetweenAttacks) {
        return MeleeAttack.create((int)cooldownBetweenAttacks);
    }

    public static <E extends LivingEntity> BehaviorControl<E> createEraseMemoryIf(Predicate<E> shouldEraseMemory, MemoryModuleType<?> erasingMemory) {
        return EraseMemoryIf.create(shouldEraseMemory, erasingMemory);
    }

    public static <E extends Mob> BehaviorControl<E> createStartAttacking(Function<E, Optional<? extends LivingEntity>> targetFinder) {
        return StartAttacking.create(targetFinder);
    }

    public static ResourceLocation toLoc(String namespace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static ResourceLocation toLoc(String location) {
        return ResourceLocation.parse((String)location);
    }

    public static void writeComponent(FriendlyByteBuf packetBuffer, Component component) {
        ComponentSerialization.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)packetBuffer), (Object)component);
    }

    public static Component readComponent(FriendlyByteBuf packetBuffer) {
        return (Component)ComponentSerialization.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)packetBuffer));
    }

    public static void setupForEntityInInventory(Quaternionf quaternion) {
        Lighting.setupForEntityInInventory((Quaternionf)quaternion);
    }

    public static ItemStack transmuteCopy(ItemStack original, Item toTransmute, int count) {
        return original.transmuteCopy((ItemLike)toTransmute, 0);
    }

    public static class Data<T> {
        private Predicate<ItemStack> has;
        private Function<ItemStack, T> get;
        private BiConsumer<ItemStack, T> set;
        private Consumer<ItemStack> remove;

        public Data(Predicate<ItemStack> has, Function<ItemStack, T> get, BiConsumer<ItemStack, T> set, Consumer<ItemStack> remove) {
            this.has = has;
            this.get = get;
            this.set = set;
        }

        public boolean hasData(ItemStack stack) {
            return this.has.test(stack);
        }

        public T getData(ItemStack stack) {
            return this.get.apply(stack);
        }

        public T getDataOrDefault(ItemStack stack, T defaultValue) {
            return this.hasData(stack) ? this.getData(stack) : defaultValue;
        }

        public void setData(ItemStack stack, T data) {
            this.set.accept(stack, (ItemStack)data);
        }

        public void copyData(ItemStack fromStack, ItemStack toStack) {
            this.setData(toStack, this.getData(fromStack));
        }

        public void editData(ItemStack stack, Function<T, T> func) {
            this.setData(stack, func.apply(this.getData(stack)));
        }

        public void removeData(ItemStack stack) {
            this.remove.accept(stack);
        }
    }

    public static class VanillaComponents {
        public static final Data<FoodProperties> FOOD = new Data<FoodProperties>(stack -> stack.has(DataComponents.FOOD), stack -> (FoodProperties)stack.get(DataComponents.FOOD), (stack, dat) -> stack.set(DataComponents.FOOD, dat), stack -> stack.remove(DataComponents.FOOD));
    }

    public static class Client {
        public static void renderToBuffer(Model model, PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, Color color) {
            model.renderToBuffer(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, color.toIntARGB());
        }

        public static void renderToBuffer(Model model, PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay) {
            Client.renderToBuffer(model, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, new Color(1.0f, 1.0f, 1.0f));
        }
    }
}

